/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.ColorPanel;
import com.lightdev.app.shtm.EffectPanel;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.TitledPickList;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class FontPanel
extends JPanel
implements TitledPickList.TitledPickListListener,
ColorPanel.ColorPanelListener {
    JTextField sample = new JTextField();
    private Vector fontComponents = new Vector(0);

    public FontPanel(boolean pickBgColor) {
        this.setLayout(new BorderLayout(5, 5));
        this.sample.setText("");
        this.sample.setEditable(false);
        this.sample.setPreferredSize(new Dimension(200, 50));
        this.sample.setHorizontalAlignment(0);
        this.sample.setText(Util.getResourceString("previewText"));
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.sample, "Center");
        previewPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("previewLabel")));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        FamilyPickList family = new FamilyPickList(ge.getAvailableFontFamilyNames(), Util.getResourceString("familyLabel"));
        family.addTitledPickListListener(this);
        this.fontComponents.add(family);
        SizePickList size = new SizePickList(SHTMLPanelImpl.FONT_SIZES, Util.getResourceString("sizeLabel"));
        size.addTitledPickListListener(this);
        this.fontComponents.add(size);
        JPanel familySizePanel = new JPanel(new BorderLayout(5, 5));
        familySizePanel.add((Component)family, "Center");
        familySizePanel.add((Component)size, "East");
        JPanel fontPartsPanel = new JPanel(new BorderLayout(5, 5));
        fontPartsPanel.add((Component)familySizePanel, "Center");
        String[] fontStyles = new String[]{Util.getResourceString("plainName"), Util.getResourceString("boldName"), Util.getResourceString("italicName"), Util.getResourceString("boldItalicName")};
        StylePickList style = new StylePickList(fontStyles, Util.getResourceString("styleLabel"));
        style.addTitledPickListListener(this);
        fontPartsPanel.add((Component)style, "East");
        this.fontComponents.add(style);
        EffectPanel linePanel = new EffectPanel();
        this.fontComponents.add(linePanel);
        JPanel colorPanel = new JPanel(new GridLayout(2, 1, 3, 3));
        colorPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("colorLabel")));
        ColorPanel fCol = new ColorPanel(Util.getResourceString("foregroundLabel"), Color.black, CSS.Attribute.COLOR);
        fCol.addColorPanelListener(this);
        this.fontComponents.add(fCol);
        colorPanel.add(fCol);
        this.sample.setForeground(Color.black);
        if (pickBgColor) {
            ColorPanel bCol = new ColorPanel(Util.getResourceString("backgroundLabel"), Color.white, CSS.Attribute.BACKGROUND_COLOR);
            bCol.addColorPanelListener(this);
            this.fontComponents.add(bCol);
            colorPanel.add(bCol);
            this.sample.setBackground(Color.white);
        }
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)linePanel, "North");
        eastPanel.add((Component)colorPanel, "South");
        this.add((Component)fontPartsPanel, "Center");
        this.add((Component)eastPanel, "East");
        this.add((Component)previewPanel, "South");
        this.add((Component)new JPanel(), "North");
        this.add((Component)new JPanel(), "West");
    }

    public FontPanel(AttributeSet a, boolean pickBgColor) {
        this(pickBgColor);
        this.setAttributes(a);
    }

    public void colorChanged(ColorPanel.ColorPanelEvent e) {
        ColorPanel source = (ColorPanel)e.getSource();
        if (source.getAttributeKey() == CSS.Attribute.COLOR) {
            this.sample.setForeground(source.getColor());
        } else if (source.getAttributeKey() == CSS.Attribute.BACKGROUND_COLOR) {
            this.sample.setBackground(source.getColor());
        }
    }

    public void setAttributes(AttributeSet a) {
        Enumeration components = this.fontComponents.elements();
        while (components.hasMoreElements()) {
            ((AttributeComponent)components.nextElement()).setValue(a);
        }
    }

    public AttributeSet getAttributes() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        Enumeration components = this.fontComponents.elements();
        while (components.hasMoreElements()) {
            attributes.addAttributes(((AttributeComponent)components.nextElement()).getValue());
        }
        return attributes;
    }

    public AttributeSet getAttributes(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            Enumeration components = this.fontComponents.elements();
            while (components.hasMoreElements()) {
                attributes.addAttributes(((AttributeComponent)components.nextElement()).getValue(includeUnchanged));
            }
            return attributes;
        }
        return this.getAttributes();
    }

    public void reset() {
        for (int i = 0; i < this.fontComponents.size(); ++i) {
            Object c = this.fontComponents.get(i);
            if (c instanceof FamilyPickList) {
                ((FamilyPickList)c).reset();
                continue;
            }
            if (c instanceof SizePickList) {
                ((SizePickList)c).reset();
                continue;
            }
            if (!(c instanceof StylePickList)) continue;
            ((StylePickList)c).reset();
        }
    }

    public void valueChanged(TitledPickList.TitledPickListEvent e) {
        Object source = e.getSource();
        Font saveFont = this.sample.getFont();
        if (source instanceof FamilyPickList) {
            this.sample.setFont(new Font(((FamilyPickList)source).getFamily(), saveFont.getStyle(), saveFont.getSize()));
        } else if (source instanceof SizePickList) {
            this.sample.setFont(new Font(saveFont.getFamily(), saveFont.getStyle(), Integer.parseInt((String)((SizePickList)source).getSelection())));
        } else if (source instanceof StylePickList) {
            this.sample.setFont(new Font(saveFont.getFamily(), ((StylePickList)source).getFontStyle(), saveFont.getSize()));
        }
    }

    class StylePickList
    extends TitledPickList
    implements AttributeComponent {
        private int originalValue;
        private int setValCount;

        StylePickList(String[] options, String titleText) {
            super(options, titleText);
            this.setValCount = 0;
        }

        public boolean setValue(AttributeSet a) {
            String value;
            this.ignoreTextChanges = true;
            boolean success = false;
            int styleNo = 0;
            if (a.isDefined(CSS.Attribute.FONT_WEIGHT) && (value = a.getAttribute(CSS.Attribute.FONT_WEIGHT).toString()).equalsIgnoreCase(StyleConstants.Bold.toString())) {
                ++styleNo;
            }
            if (a.isDefined(CSS.Attribute.FONT_STYLE) && (value = a.getAttribute(CSS.Attribute.FONT_STYLE).toString()).equalsIgnoreCase(StyleConstants.Italic.toString())) {
                styleNo += 2;
            }
            this.setSelection(styleNo);
            if (++this.setValCount < 2) {
                this.originalValue = styleNo;
            }
            this.ignoreTextChanges = false;
            return success;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            int styleNo = this.getIndex();
            switch (styleNo) {
                case 0: {
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, "normal");
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, "normal");
                    break;
                }
                case 1: {
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, "normal");
                    break;
                }
                case 2: {
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, "normal");
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                    break;
                }
                case 3: {
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                }
            }
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            if (includeUnchanged) {
                String value = "normal";
                SimpleAttributeSet set = new SimpleAttributeSet();
                int styleNo = this.getIndex();
                switch (styleNo) {
                    case 0: {
                        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, value);
                        break;
                    }
                    case 1: {
                        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                        break;
                    }
                    case 2: {
                        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                        break;
                    }
                    case 3: {
                        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                    }
                }
                return set;
            }
            return this.getValue();
        }

        public int getFontStyle() {
            int fontStyle = 0;
            switch (this.getIndex()) {
                case 0: {
                    fontStyle = 0;
                    break;
                }
                case 1: {
                    fontStyle = 1;
                    break;
                }
                case 2: {
                    fontStyle = 2;
                    break;
                }
                case 3: {
                    fontStyle = 3;
                }
            }
            return fontStyle;
        }

        public void reset() {
            this.setValCount = 0;
            this.originalValue = -2;
        }
    }

    class SizePickList
    extends TitledPickList
    implements AttributeComponent {
        private int setValCount;
        private String originalValue;

        SizePickList(String[] options, String titleText) {
            super(options, titleText);
            this.setValCount = 0;
        }

        public boolean setValue(AttributeSet a) {
            this.ignoreTextChanges = true;
            int size = Util.styleSheet().getFont(a).getSize();
            String newSelection = Integer.toString(size);
            this.setSelection(newSelection);
            if (++this.setValCount < 2) {
                this.originalValue = newSelection;
            }
            return true;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            SimpleAttributeSet set = new SimpleAttributeSet();
            String value = (String)this.getSelection();
            if (includeUnchanged || this.originalValue == null && value != null || this.originalValue != null && !this.originalValue.equalsIgnoreCase(value)) {
                String relativeSize = Integer.toString(this.getIndex() + 1);
                set.addAttribute(HTML.Attribute.SIZE, relativeSize);
                Util.styleSheet().addCSSAttributeFromHTML(set, CSS.Attribute.FONT_SIZE, relativeSize);
            }
            return set;
        }

        public AttributeSet getValue() {
            return this.getValue(false);
        }

        public void reset() {
            this.setValCount = 0;
            this.originalValue = null;
        }
    }

    class FamilyPickList
    extends TitledPickList
    implements AttributeComponent {
        private int setValCount;
        private Object originalValue;

        FamilyPickList(String[] options, String titleText) {
            super(options, titleText);
            this.setValCount = 0;
        }

        public boolean setValue(AttributeSet a) {
            this.ignoreTextChanges = true;
            String newSelection = Util.styleSheet().getFont(a).getFamily();
            this.setSelection(newSelection);
            this.ignoreTextChanges = false;
            if (++this.setValCount < 2) {
                this.originalValue = newSelection;
            }
            return true;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            SimpleAttributeSet set = new SimpleAttributeSet();
            Object value = this.getSelection();
            if (includeUnchanged || this.originalValue == null && value != null || this.originalValue != null && value != null && !this.originalValue.toString().equalsIgnoreCase(value.toString())) {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_FAMILY, value.toString());
                set.addAttribute(HTML.Attribute.FACE, value.toString());
            }
            return set;
        }

        public AttributeSet getValue() {
            return this.getValue(false);
        }

        public String getFamily() {
            return (String)this.getSelection();
        }

        public void reset() {
            this.setValCount = 0;
            this.originalValue = null;
        }
    }
}

