/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class ResultManager {
    int numberOfOutputTypes;
    GUI gui;
    String[] header;
    long elapsedTime;
    int resultsPointer;
    String text;
    boolean reverseResults;
    boolean number = true;
    int offset;
    String temp;
    String[] results;
    boolean statusBarVisible = false;
    JFrame newWindow;
    Component[] outputCache;
    Component[] outputInNewWindowCache;
    final String GERVERB_EXPRESSION = "^ to ([:alpha:]|[\\-\\.])*(( *)|(, .+)) $";
    final String GERNOUN_EXPRESSION = "^ ([:alpha:]|[\\-\\.])*(( *)|(, ([:alpha:]|(\\-))+ ))$";
    final String GERWORD_EXPRESSION = "^ ([:alpha:]|[\\-\\.\\/])*( ?(\\(|\\/).*(\\)|\\/))* $";
    final String HUNWORD_EXPRESSION = "^ ([:alpha:]|[\\-\\.\\/])+( ?, ?- ?([:alpha:]|[\\-\\.\\/])*)*( ?(\\(|\\/).*(\\)|\\/))* $";
    RE verbRegexp;
    RE nounRegexp;
    RE wordRegexp;
    Prefs prefs;
    OutputTypeChooserToolBar outputTypeChooserToolBar;

    public ResultManager(boolean reverseResults, GUI gui, int maxNumberOfResults, Prefs prefs, String text) {
        this.prefs = prefs;
        this.reverseResults = reverseResults;
        this.gui = gui;
        this.text = text;
        try {
            if (!reverseResults) {
                this.verbRegexp = new RE("^ to ([:alpha:]|[\\-\\.])*(( *)|(, .+)) $");
                this.nounRegexp = new RE("^ ([:alpha:]|[\\-\\.])*(( *)|(, ([:alpha:]|(\\-))+ ))$");
                this.wordRegexp = new RE("^ ([:alpha:]|[\\-\\.\\/])*( ?(\\(|\\/).*(\\)|\\/))* $");
            } else {
                this.wordRegexp = new RE("^ ([:alpha:]|[\\-\\.\\/])+( ?, ?- ?([:alpha:]|[\\-\\.\\/])*)*( ?(\\(|\\/).*(\\)|\\/))* $");
            }
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
        if (this.number) {
            this.header = new String[3];
            this.header[this.offset] = Resources.getString("Number");
            ++this.offset;
        } else {
            this.header = new String[2];
        }
        this.results = new String[maxNumberOfResults + 1];
        if (reverseResults) {
            this.header[this.offset] = Resources.getString("Column2");
            this.header[this.offset + 1] = Resources.getString("Column1");
            this.numberOfOutputTypes = 2;
            this.text = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(text).append('\"').append(" (").append(Resources.getString("Column2")).append(" - ").append(Resources.getString("Column1")).append(")")));
        } else {
            this.header[this.offset] = Resources.getString("Column1");
            this.header[this.offset + 1] = Resources.getString("Column2");
            this.numberOfOutputTypes = 2;
            this.text = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(text).append('\"').append(" (").append(Resources.getString("Column1")).append(" - ").append(Resources.getString("Column2")).append(")")));
        }
        this.outputCache = new Component[this.numberOfOutputTypes];
        this.outputInNewWindowCache = new Component[this.numberOfOutputTypes];
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() {
        this.outputTypeChooserToolBar = new OutputTypeChooserToolBar(this.prefs, this.numberOfOutputTypes);
        this.outputTypeChooserToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.outputTypeChooserToolBar.increment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputTypeChooserToolBar.increment();
                ResultManager.this.outputManager(false);
            }
        });
        this.outputTypeChooserToolBar.decrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputTypeChooserToolBar.decrement();
                ResultManager.this.outputManager(false);
            }
        });
        this.outputTypeChooserToolBar.newWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputManager(true);
            }
        });
    }

    public void putResult(String result) {
        this.results[this.resultsPointer] = result;
        if (result == null) {
            if (this.resultsPointer > 0) {
                Arrays.sort(this.results, 0, this.resultsPointer - 1);
                this.outputManager(false);
            } else {
                this.updateStatusBar();
            }
            return;
        }
        ++this.resultsPointer;
    }

    Component generateTVNSeparatedOutput() {
        int verbCount = 0;
        int nounCount = 0;
        int termCount = 0;
        String[][] terms = new String[this.resultsPointer][this.header.length];
        String[][] nouns = new String[this.resultsPointer][this.header.length];
        String[][] verbs = new String[this.resultsPointer][this.header.length];
        String result = null;
        int m = 0;
        while ((result = this.results[m++]) != null) {
            int nn;
            int n = 2;
            while (result.charAt(n) != ':') {
                ++n;
            }
            this.temp = new String(result.substring(0, n));
            if (this.verbRegexp.match(this.temp)) {
                verbs[verbCount][this.offset] = this.temp;
                nn = ++n;
                while (result.charAt(n) != ':') {
                    ++n;
                }
                verbs[verbCount][this.offset + 1] = result.substring(nn, n);
                if (this.offset == 1) {
                    new String();
                    verbs[verbCount][this.offset - 1] = String.valueOf(verbCount + 1);
                }
                ++verbCount;
                continue;
            }
            if (this.nounRegexp.match(this.temp)) {
                nouns[nounCount][this.offset] = this.temp;
                nn = ++n;
                while (result.charAt(n) != ':') {
                    ++n;
                }
                nouns[nounCount][this.offset + 1] = result.substring(nn, n);
                if (this.offset == 1) {
                    new String();
                    nouns[nounCount][this.offset - 1] = String.valueOf(nounCount + 1);
                }
                ++nounCount;
                continue;
            }
            terms[termCount][this.offset] = this.temp;
            nn = ++n;
            while (result.charAt(n) != ':') {
                ++n;
            }
            terms[termCount][this.offset + 1] = result.substring(nn, n);
            if (this.offset == 1) {
                new String();
                terms[termCount][this.offset - 1] = String.valueOf(termCount + 1);
            }
            ++termCount;
        }
        OutputTableModel termTableModel = new OutputTableModel(terms, termCount, this.header);
        OutputTableModel verbTableModel = new OutputTableModel(verbs, verbCount, this.header);
        OutputTableModel nounTableModel = new OutputTableModel(nouns, nounCount, this.header);
        JTabbedPane outputTabbedPane = new JTabbedPane();
        JTable termTable = new JTable(termTableModel);
        JTable verbTable = new JTable(verbTableModel);
        JTable nounTable = new JTable(nounTableModel);
        if (this.number) {
            TableColumn col = termTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
            col = verbTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
            col = nounTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
        }
        JScrollPane termScrollPane = new JScrollPane(termTable);
        JScrollPane verbScrollPane = new JScrollPane(verbTable);
        JScrollPane nounScrollPane = new JScrollPane(nounTable);
        if (nounCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Nouns")))).append(" (").append(nounCount).append(" ").append(Resources.getString("Results")).append(")"))), nounScrollPane);
        } else if (nounCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Nouns")))).append(" (").append(nounCount).append(" ").append(Resources.getString("Result")).append(")"))), nounScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Nouns"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), nounScrollPane);
            outputTabbedPane.setEnabledAt(0, false);
        }
        if (verbCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Verbs")))).append(" (").append(verbCount).append(" ").append(Resources.getString("Results")).append(")"))), verbScrollPane);
        } else if (verbCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Verbs")))).append(" (").append(verbCount).append(" ").append(Resources.getString("Result")).append(")"))), verbScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Verbs"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), verbScrollPane);
            outputTabbedPane.setEnabledAt(1, false);
        }
        if (termCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(termCount).append(" ").append(Resources.getString("Results")).append(")"))), termScrollPane);
        } else if (termCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(termCount).append(" ").append(Resources.getString("Result")).append(")"))), termScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Terms"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), termScrollPane);
            outputTabbedPane.setEnabledAt(2, false);
        }
        for (int n = 0; n < outputTabbedPane.getTabCount(); ++n) {
            if (!outputTabbedPane.isEnabledAt(n)) continue;
            outputTabbedPane.setSelectedIndex(n);
            break;
        }
        termTable.addMouseListener(new TablePopup(termTable));
        verbTable.addMouseListener(new TablePopup(verbTable));
        nounTable.addMouseListener(new TablePopup(nounTable));
        return outputTabbedPane;
    }

    Component generateMassOutput() {
        int rowCount = 0;
        String[][] rows = new String[this.resultsPointer][this.header.length];
        String result = null;
        int m = 0;
        while ((result = this.results[m++]) != null) {
            int n = 0;
            while (result.charAt(n) != ':') {
                ++n;
            }
            rows[rowCount][this.offset] = result.substring(0, n);
            int nn = ++n;
            while (result.charAt(n) != ':') {
                ++n;
            }
            rows[rowCount][this.offset + 1] = result.substring(nn, n);
            if (this.offset == 1) {
                new String();
                rows[rowCount][this.offset - 1] = String.valueOf(rowCount + 1);
            }
            ++rowCount;
        }
        OutputTableModel massTableModel = new OutputTableModel(rows, rowCount, this.header);
        JTable massTable = new JTable(massTableModel);
        if (this.number) {
            TableColumn col = massTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
        }
        JScrollPane massScrollPane = new JScrollPane(massTable);
        massTable.addMouseListener(new TablePopup(massTable));
        return massScrollPane;
    }

    Component generateTWSeparatedOutput() {
        int wordCount = 0;
        int termCount = 0;
        int m = 0;
        String result = null;
        String[][] terms = new String[this.resultsPointer][this.header.length];
        String[][] words = new String[this.resultsPointer][this.header.length];
        while ((result = this.results[m++]) != null) {
            int nn;
            int n = 0;
            while (result.charAt(n) != ':') {
                ++n;
            }
            this.temp = new String(result.substring(0, n));
            if (this.wordRegexp.match(this.temp)) {
                words[wordCount][this.offset] = this.temp;
                nn = ++n;
                while (result.charAt(n) != ':') {
                    ++n;
                }
                words[wordCount][this.offset + 1] = result.substring(nn, n);
                if (this.offset == 1) {
                    new String();
                    words[wordCount][this.offset - 1] = String.valueOf(wordCount + 1);
                }
                ++wordCount;
                continue;
            }
            terms[termCount][this.offset] = this.temp;
            nn = ++n;
            while (result.charAt(n) != ':') {
                ++n;
            }
            terms[termCount][this.offset + 1] = result.substring(nn, n);
            if (this.offset == 1) {
                new String();
                terms[termCount][this.offset - 1] = String.valueOf(termCount + 1);
            }
            ++termCount;
        }
        OutputTableModel termTableModel = new OutputTableModel(terms, termCount, this.header);
        OutputTableModel wordTableModel = new OutputTableModel(words, wordCount, this.header);
        JTabbedPane outputTabbedPane = new JTabbedPane();
        JTable termTable = new JTable(termTableModel);
        JTable wordTable = new JTable(wordTableModel);
        if (this.number) {
            TableColumn col = termTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
            col = wordTable.getColumnModel().getColumn(0);
            col.setMaxWidth(65);
        }
        JScrollPane termScrollPane = new JScrollPane(termTable);
        JScrollPane wordScrollPane = new JScrollPane(wordTable);
        if (wordCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Words")))).append(" (").append(wordCount).append(" ").append(Resources.getString("Results")).append(")"))), wordScrollPane);
        } else if (wordCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Words")))).append(" (").append(wordCount).append(" ").append(Resources.getString("Result")).append(")"))), wordScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Words"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), wordScrollPane);
            outputTabbedPane.setEnabledAt(0, false);
        }
        if (termCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(termCount).append(" ").append(Resources.getString("Results")).append(")"))), termScrollPane);
        } else if (termCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(termCount).append(" ").append(Resources.getString("Result")).append(")"))), termScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Terms"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), termScrollPane);
            outputTabbedPane.setEnabledAt(1, false);
        }
        for (int n = 0; n < outputTabbedPane.getTabCount(); ++n) {
            if (!outputTabbedPane.isEnabledAt(n)) continue;
            outputTabbedPane.setSelectedIndex(n);
            break;
        }
        termTable.addMouseListener(new TablePopup(termTable));
        wordTable.addMouseListener(new TablePopup(wordTable));
        return outputTabbedPane;
    }

    void showOutput(Component component) {
        this.gui.outputPanel.remove(0);
        this.gui.outputPanel.setBackground(UIManager.getColor("Panel.background"));
        BorderLayout cfr_ignored_0 = (BorderLayout)this.gui.outputPanel.getLayout();
        this.gui.outputPanel.add(component, "Center", 0);
        this.gui.outputPanel.validate();
        this.gui.outputPanel.repaint();
    }

    void showOutputInNewWindow(Component comp) {
        if (this.newWindow != null) {
            ((Component)this.newWindow).setVisible(true);
            return;
        }
        this.newWindow = new JFrame(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("OutputFor")))).append(" ").append(this.text))));
        final BorderLayout borderLayout = new BorderLayout();
        Prefs tempPrefs = new Prefs();
        tempPrefs.lastSelectedOutputType = this.prefs.lastSelectedOutputType;
        final OutputTypeChooserToolBar typeChooser = new OutputTypeChooserToolBar(tempPrefs, this.numberOfOutputTypes, false);
        typeChooser.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JLabel label = new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("NumberOfResults")))).append(this.resultsPointer).append(Resources.getString("TakenTimePrefix")).append((float)this.elapsedTime / (float)1000).append(Resources.getString("TakenTimePostfix")).append("    "))), IconBank.info, 0);
        toolBar.add(label);
        toolBar.add(typeChooser);
        this.newWindow.getContentPane().setLayout(borderLayout);
        this.newWindow.getContentPane().add(comp, "Center", 0);
        this.newWindow.getContentPane().add((Component)toolBar, "South");
        ((Frame)this.newWindow).setIconImage(IconBank.world.getImage());
        this.newWindow.pack();
        ((Component)this.newWindow).setSize(500, 350);
        ((Component)this.newWindow).setVisible(true);
        typeChooser.increment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                typeChooser.increment();
                Component comp = ResultManager.this.outputFactory(typeChooser, true);
                ResultManager.this.newWindow.getContentPane().remove(0);
                ResultManager.this.newWindow.getContentPane().add(comp, "Center", 0);
                ResultManager.this.newWindow.validate();
                ResultManager.this.newWindow.repaint();
            }
        });
        typeChooser.decrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                typeChooser.decrement();
                Component comp = ResultManager.this.outputFactory(typeChooser, true);
                ResultManager.this.newWindow.getContentPane().remove(0);
                ResultManager.this.newWindow.getContentPane().add(comp, "Center", 0);
                ResultManager.this.newWindow.validate();
                ResultManager.this.newWindow.repaint();
            }
        });
    }

    public void updateStatusBar() {
        if (this.statusBarVisible) {
            return;
        }
        String message = null;
        if (this.resultsPointer > 0) {
            message = new String(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("NumberOfResults")))).append(this.resultsPointer).append(Resources.getString("TakenTimePrefix")).append((float)this.elapsedTime / (float)1000).append(Resources.getString("TakenTimePostfix")).append("    "))));
            this.gui.setStatusMessage(message, IconBank.info, this.outputTypeChooserToolBar);
        } else {
            this.gui.putMessageToOutputPanel(Resources.getString("NoMatch"), IconBank.info);
        }
        this.statusBarVisible = true;
    }

    void outputManager(boolean showInNewWindow) {
        if (showInNewWindow) {
            this.showOutputInNewWindow(this.outputFactory(this.outputTypeChooserToolBar, true));
        } else {
            this.showOutput(this.outputFactory(this.outputTypeChooserToolBar, false));
        }
        this.updateStatusBar();
    }

    Component outputFactory(OutputTypeChooserToolBar outputTypeChooserToolBar, boolean newWindow) {
        int selected = outputTypeChooserToolBar.getSelected();
        if (!newWindow && this.outputCache[selected] == null || newWindow && this.outputInNewWindowCache[selected] == null) {
            Component comp;
            switch (outputTypeChooserToolBar.getSelected()) {
                case 0: {
                    comp = this.generateMassOutput();
                    break;
                }
                case 1: {
                    comp = this.generateTWSeparatedOutput();
                    break;
                }
                case 2: {
                    comp = this.generateTVNSeparatedOutput();
                    break;
                }
                default: {
                    comp = this.generateTWSeparatedOutput();
                }
            }
            if (newWindow) {
                this.outputInNewWindowCache[selected] = comp;
            } else {
                this.outputCache[selected] = comp;
            }
        }
        if (newWindow) {
            return this.outputInNewWindowCache[selected];
        }
        return this.outputCache[selected];
    }
}

