/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class GUI
extends JPanel {
    Prefs prefs;
    Clipboard sysBoard = this.getToolkit().getSystemClipboard();
    boolean simpleGUI;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel outputPanel = new JPanel();
    JLabel headerLabel = new JLabel();
    JLabel wordToFindLabel = new JLabel();
    JToolBar jToolBar1 = new JToolBar();
    JToolBar statusBar = new JToolBar();
    JToolBar upperStatusBar = new JToolBar();
    JButton findButton = new JButton();
    JButton pasteButton = new JButton();
    JTextField inputTextField = new JTextField();
    ExpressionTypeChooserToolBar expressionTypeChooserToolBar;
    boolean expressionTypeChooserToolBarVisible = false;
    TitledBorder titledBorder1;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BoxLayout boxLayout = new BoxLayout(this, 1);

    public GUI(Prefs prefs) {
        this(prefs, false);
    }

    public GUI(Prefs prefs, boolean simpleGUI) {
        this.prefs = prefs;
        this.simpleGUI = simpleGUI;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.boxLayout);
        this.setForeground(Color.gray);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setMinimumSize(new Dimension(380, 150));
        this.setPreferredSize(new Dimension(380, 150));
        this.headerLabel.setAlignmentY(0.0f);
        this.headerLabel.setMaximumSize(new Dimension(450, 50));
        this.headerLabel.setMinimumSize(new Dimension(450, 50));
        this.headerLabel.setPreferredSize(new Dimension(450, 50));
        this.headerLabel.setIconTextGap(0);
        this.headerLabel.setVerticalAlignment(1);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setAlignmentY(0.0f);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.jPanel1.setMinimumSize(new Dimension(300, 50));
        this.jPanel1.setPreferredSize(new Dimension(300, 50));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel1.add((Component)this.headerLabel, "Center");
        if (!this.simpleGUI) {
            this.expressionTypeChooserToolBar = new ExpressionTypeChooserToolBar(this.prefs);
            this.findButton.setAlignmentY(0.0f);
            this.findButton.setMaximumSize(new Dimension(79, 25));
            this.findButton.setMinimumSize(new Dimension(50, 25));
            this.findButton.setPreferredSize(new Dimension(50, 25));
            this.findButton.setToolTipText(Resources.getString("GoToolTip"));
            this.findButton.setIcon(IconBank.rightArrows);
            this.findButton.setMargin(new Insets(2, 2, 2, 2));
            this.findButton.setText(Resources.getString("Go"));
            this.findButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUI.this.findButton_actionPerformed(e);
                }
            });
            this.pasteButton.setAlignmentY(0.0f);
            this.pasteButton.setMaximumSize(new Dimension(79, 25));
            this.pasteButton.setMinimumSize(new Dimension(35, 25));
            this.pasteButton.setPreferredSize(new Dimension(35, 25));
            this.pasteButton.setToolTipText(Resources.getString("PasteToolTip"));
            this.pasteButton.setIcon(IconBank.paste);
            this.pasteButton.setMargin(new Insets(2, 2, 2, 2));
            this.pasteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUI.this.pasteButton_actionPerformed(e);
                }
            });
            this.inputTextField.setAlignmentX(0.0f);
            this.inputTextField.setAlignmentY(0.0f);
            this.inputTextField.setMaximumSize(new Dimension(26000, 25));
            this.inputTextField.setMinimumSize(new Dimension(63, 25));
            this.inputTextField.setPreferredSize(new Dimension(210, 25));
            this.inputTextField.setText(this.prefs.textFieldContent);
            this.inputTextField.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    GUI.this.inputTextField_mousePressed(e);
                }
            });
            this.inputTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUI.this.inputTextField_actionPerformed(e);
                }
            });
            this.inputTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    GUI.this.inputTextField_keyTyped(e);
                }
            });
            this.inputTextField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    GUI.this.inputTextField_focusGained(e);
                }
            });
            this.expressionTypeChooserToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.jToolBar1.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.jToolBar1.setAlignmentX(0.0f);
            this.jToolBar1.setBorder(BorderFactory.createEtchedBorder());
            this.jToolBar1.setFloatable(false);
            this.jToolBar1.add((Component)this.wordToFindLabel, null);
            this.jToolBar1.add((Component)this.inputTextField, null);
            this.jToolBar1.add((Component)this.pasteButton, null);
            this.jToolBar1.add((Component)this.findButton, null);
            this.jToolBar1.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.statusBar.setAlignmentX(0.0f);
        this.statusBar.setAlignmentY(0.0f);
        this.statusBar.setFloatable(false);
        this.outputPanel.setLayout(this.borderLayout2);
        this.outputPanel.setBackground(Color.white);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setAlignmentX(0.0f);
        this.jPanel2.setAlignmentY(0.0f);
        this.jPanel2.add((Component)this.outputPanel, "Center");
        this.wordToFindLabel.setAlignmentY(0.0f);
        this.wordToFindLabel.setMaximumSize(new Dimension(150, 24));
        this.wordToFindLabel.setMinimumSize(new Dimension(100, 24));
        this.wordToFindLabel.setIcon(IconBank.magnify);
        this.wordToFindLabel.setIconTextGap(0);
        this.add((Component)this.jPanel1, null);
        if (!this.simpleGUI) {
            this.add((Component)this.jToolBar1, null);
        }
        this.add((Component)this.jPanel2, null);
    }

    public String getTextFromClipboard() {
        Transferable data = this.sysBoard.getContents(this);
        String incoming = null;
        if (data != null) {
            try {
                incoming = (String)data.getTransferData(DataFlavor.stringFlavor);
            }
            catch (IOException iox) {
                System.out.println("getTextFronClipboard: IOException");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return incoming;
    }

    public void setStatusMessage(final String message, final ImageIcon icon) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUI.this.statusBar.removeAll();
                JLabel statusLabel = new JLabel(message, icon, 0);
                GUI.this.statusBar.add(statusLabel);
                GUI.this.jPanel2.add((Component)GUI.this.statusBar, "South");
                GUI.this.jPanel2.validate();
            }
        });
    }

    public void setStatusMessage(final String message, final ImageIcon icon, final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUI.this.statusBar.removeAll();
                JLabel statusLabel = new JLabel(message, icon, 0);
                GUI.this.statusBar.add(statusLabel);
                GUI.this.statusBar.add(component);
                GUI.this.jPanel2.add((Component)GUI.this.statusBar, "South");
                GUI.this.jPanel2.validate();
            }
        });
    }

    void inputTextField_focusGained(FocusEvent e) {
        this.showExpressionChooser();
    }

    void inputTextField_keyTyped(KeyEvent e) {
        if (e.getKeyChar() != '\n') {
            this.showExpressionChooser();
        }
    }

    public void setHeader(ImageIcon icon) {
        this.headerLabel.setIcon(icon);
    }

    public void showExpressionChooser() {
        if (!this.expressionTypeChooserToolBarVisible) {
            this.jPanel2.add((Component)this.expressionTypeChooserToolBar, "North");
            this.jPanel2.validate();
            this.expressionTypeChooserToolBarVisible = true;
        }
    }

    public void removeExpressionChooser() {
        if (this.expressionTypeChooserToolBarVisible) {
            this.jPanel2.remove(this.expressionTypeChooserToolBar);
            this.jPanel2.validate();
            this.expressionTypeChooserToolBarVisible = false;
        }
    }

    void findButton_actionPerformed(ActionEvent e) {
        this.removeExpressionChooser();
    }

    void inputTextField_actionPerformed(ActionEvent e) {
        this.removeExpressionChooser();
    }

    void pasteButton_actionPerformed(ActionEvent e) {
        this.showExpressionChooser();
    }

    public void loadHtmlToOutputPanel(final URL url, String loadingMessage, ImageIcon loadingMessageIcon, final String statusBarMessage, final ImageIcon statusBarMessageIcon) {
        this.putMessageToOutputPanel(loadingMessage, loadingMessageIcon);
        new Thread(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        HtmlPane htmlPane = new HtmlPane(9.access$0(this.this$1));
                        9.access$1(this.this$1).outputPanel.removeAll();
                        9.access$1(this.this$1).outputPanel.add(htmlPane);
                        9.access$1(this.this$1).outputPanel.validate();
                        9.access$1(this.this$1).setStatusMessage(9.access$2(this.this$1), 9.access$3(this.this$1));
                    }
                });
            }

            static /* synthetic */ GUI access$1(9 x$0) {
                return x$0.GUI.this;
            }

            static /* synthetic */ URL access$0(9 x$0) {
                return x$0.url;
            }

            static /* synthetic */ String access$2(9 x$0) {
                return x$0.statusBarMessage;
            }

            static /* synthetic */ ImageIcon access$3(9 x$0) {
                return x$0.statusBarMessageIcon;
            }
        }.start();
    }

    public void putMessageToOutputPanel(final String message, final ImageIcon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.jPanel2.remove(this.statusBar);
            this.outputPanel.removeAll();
            this.outputPanel.setBackground(new Color(255, 255, 255));
            JLabel messageLabel = new JLabel(message, icon, 0);
            this.outputPanel.add(messageLabel);
            this.jPanel2.validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUI.this.jPanel2.remove(GUI.this.statusBar);
                    GUI.this.outputPanel.removeAll();
                    GUI.this.outputPanel.setBackground(new Color(255, 255, 255));
                    JLabel messageLabel = new JLabel(message, icon, 0);
                    GUI.this.outputPanel.add(messageLabel);
                    GUI.this.jPanel2.validate();
                }
            });
        }
    }

    void inputTextField_mousePressed(MouseEvent e) {
        this.showExpressionChooser();
    }
}

