/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.Date;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.Status;

public final class ConversionUtility {
    public static SVNEntryInfo[] convert(Info2[] infos) {
        if (infos == null) {
            return null;
        }
        SVNEntryInfo[] retVal = new SVNEntryInfo[infos.length];
        int i = 0;
        while (i < infos.length) {
            retVal[i] = ConversionUtility.convert(infos[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNEntryInfo convert(Info2 info) {
        return new SVNEntryInfo(info.getPath(), info.getUrl(), info.getRev(), info.getKind(), info.getReposRootUrl(), info.getReposUUID(), info.getLastChangedRev(), info.getLastChangedDate() == null ? 0L : info.getLastChangedDate().getTime(), info.getLastChangedAuthor(), ConversionUtility.convert(info.getLock()), info.isHasWcInfo(), info.getSchedule(), info.getCopyFromUrl(), info.getCopyFromRev(), info.getTextTime() == null ? 0L : info.getTextTime().getTime(), info.getPropTime() == null ? 0L : info.getPropTime().getTime(), info.getChecksum(), info.getConflictOld(), info.getConflictNew(), info.getConflictWrk(), info.getPrejfile(), -2, null);
    }

    public static SVNLogEntry[] convert(LogMessage[] msgs) {
        if (msgs == null) {
            return null;
        }
        SVNLogEntry[] retVal = new SVNLogEntry[msgs.length];
        int i = 0;
        while (i < msgs.length) {
            retVal[i] = ConversionUtility.convert(msgs[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNLogEntry convert(LogMessage msg) {
        return new SVNLogEntry(msg.getRevisionNumber(), msg.getDate() == null ? 0L : msg.getDate().getTime(), msg.getAuthor(), msg.getMessage(), ConversionUtility.convert(msg.getChangedPaths()), false);
    }

    public static SVNLogPath[] convert(ChangePath[] paths) {
        if (paths == null) {
            return null;
        }
        SVNLogPath[] retVal = new SVNLogPath[paths.length];
        int i = 0;
        while (i < paths.length) {
            retVal[i] = ConversionUtility.convert(paths[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNLogPath convert(ChangePath path) {
        return new SVNLogPath(path.getPath(), path.getAction(), path.getCopySrcPath(), path.getCopySrcRevision());
    }

    public static SVNProperty[] convert(PropertyData[] data) {
        if (data == null) {
            return null;
        }
        SVNProperty[] retVal = new SVNProperty[data.length];
        int i = 0;
        while (i < data.length) {
            retVal[i] = ConversionUtility.convert(data[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNProperty convert(PropertyData data) {
        if (data == null) {
            return null;
        }
        String value = data.getValue() != null ? data.getValue() : (data.getData() != null ? new String(data.getData()) : null);
        return new SVNProperty(data.getName(), value);
    }

    public static SVNChangeStatus[] convert(Status[] st) {
        if (st == null) {
            return null;
        }
        SVNChangeStatus[] retVal = new SVNChangeStatus[st.length];
        int i = 0;
        while (i < st.length) {
            retVal[i] = ConversionUtility.convert(st[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus convert(Status st) {
        return new SVNChangeStatus(st.getPath(), st.getUrl(), st.getNodeKind(), st.getRevisionNumber(), st.getLastChangedRevisionNumber(), st.getLastChangedDate() == null ? 0L : st.getLastChangedDate().getTime(), st.getLastCommitAuthor(), st.getTextStatus(), st.getPropStatus(), st.getRepositoryTextStatus(), st.getRepositoryPropStatus(), st.isLocked(), st.isCopied(), st.getConflictOld(), st.getConflictNew(), st.getConflictWorking(), st.getUrlCopiedFrom(), st.getRevisionCopiedFromNumber(), st.isSwitched(), st.getLockToken(), st.getLockOwner(), st.getLockComment(), st.getLockCreationDate() == null ? 0L : st.getLockCreationDate().getTime(), ConversionUtility.convert(st.getReposLock()), st.getReposLastCmtRevisionNumber(), st.getReposLastCmtDate() == null ? 0L : st.getReposLastCmtDate().getTime(), st.getReposKind(), st.getReposLastCmtAuthor(), false, false, null);
    }

    public static SVNLock convert(Lock lock) {
        return lock == null ? null : new SVNLock(lock.getOwner(), lock.getPath(), lock.getToken(), lock.getComment(), lock.getCreationDate() == null ? 0L : lock.getCreationDate().getTime(), lock.getExpirationDate() == null ? 0L : lock.getExpirationDate().getTime());
    }

    public static BlameCallback convert(final ISVNAnnotationCallback cb) {
        return new BlameCallback(){

            public void singleLine(Date date, long revision, String author, String line) {
                cb.annotate(line, new SVNAnnotationData(revision, date == null ? 0L : date.getTime(), author, -1L, 0L, null, null));
            }
        };
    }

    public static SVNRevision convert(Revision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case 5: {
                    return SVNRevision.BASE;
                }
                case 3: {
                    return SVNRevision.COMMITTED;
                }
                case 7: {
                    return SVNRevision.HEAD;
                }
                case 4: {
                    return SVNRevision.PREVIOUS;
                }
                case 6: {
                    return SVNRevision.WORKING;
                }
                case 0: {
                    return SVNRevision.START;
                }
                case 1: {
                    return SVNRevision.fromNumber((long)((Revision.Number)rev).getNumber());
                }
            }
            return SVNRevision.fromDate((long)((Revision.DateSpec)rev).getDate().getTime());
        }
        return null;
    }

    public static Revision convert(SVNRevision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case 5: {
                    return Revision.BASE;
                }
                case 3: {
                    return Revision.COMMITTED;
                }
                case 7: {
                    return Revision.HEAD;
                }
                case 4: {
                    return Revision.PREVIOUS;
                }
                case 6: {
                    return Revision.WORKING;
                }
                case 0: {
                    return Revision.START;
                }
                case 1: {
                    return Revision.getInstance((long)((SVNRevision.Number)rev).getNumber());
                }
            }
            return Revision.getInstance((Date)new Date(((SVNRevision.Date)rev).getDate()));
        }
        return null;
    }

    public static SVNNotification convert(NotifyInformation info) {
        return new SVNNotification(info.getPath(), info.getAction(), info.getKind(), info.getMimeType(), ConversionUtility.convert(info.getLock()), info.getErrMsg(), info.getContentState(), info.getPropState(), info.getLockState(), info.getRevision());
    }

    public static ISVNNotificationCallback convert(Notify2 notify2) {
        return notify2 == null ? null : ((Notify2Wrapper)notify2).getNotify2();
    }

    public static Notify2 convert(ISVNNotificationCallback notify2) {
        return notify2 == null ? null : new Notify2Wrapper(notify2);
    }

    private ConversionUtility() {
    }

    public static class Notify2Wrapper
    implements Notify2 {
        protected ISVNNotificationCallback notify;

        public Notify2Wrapper(ISVNNotificationCallback notify) {
            this.notify = notify;
        }

        public ISVNNotificationCallback getNotify2() {
            return this.notify;
        }

        public void onNotify(NotifyInformation info) {
            this.notify.notify(ConversionUtility.convert(info));
        }
    }
}

