/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.connector.javahl.JavaHLConnector;
import org.polarion.team.svn.connector.javahl.JavaHLPlugin;
import org.tigris.subversion.javahl.ConversionUtility;
import org.tigris.subversion.javahl.SVNClient;

public class JavaHLConnectorFactory
implements ISVNConnectorFactory {
    public static final String CLIENT_ID = "org.eclipse.team.svn.connector.javahl16";
    private static boolean librariesLoaded = false;

    public ISVNConnector newInstance() {
        String error = JavaHLConnectorFactory.checkLibraries();
        if (error != null) {
            throw new RuntimeException(error);
        }
        return new JavaHLConnector();
    }

    public String getName() {
        String format = "%1$s %2$s r%3$s (for SVN %4$s, win32 platform only)";
        String fullClientVersion = this.getClientVersion();
        Pattern regex = Pattern.compile("^svn:(\\d+\\.\\d+\\.\\d+.*)\\s+\\(r(\\d+)\\)\njni:\\d+\\.\\d+\\.\\d+$");
        Matcher matcher = regex.matcher(fullClientVersion);
        if (matcher.matches()) {
            String version = matcher.group(1);
            String revision = matcher.group(2);
            return String.format(format, JavaHLPlugin.instance().getResource("ClientName"), version, revision, version);
        }
        return JavaHLPlugin.instance().getResource("ClientName");
    }

    public String getId() {
        return CLIENT_ID;
    }

    public String getClientVersion() {
        String error = JavaHLConnectorFactory.checkLibraries();
        if (error != null) {
            return error;
        }
        return SVNClient.version();
    }

    public String getVersion() {
        return JavaHLPlugin.instance().getVersionString();
    }

    public String getCompatibilityVersion() {
        return "0.7.8.I20091009-1900";
    }

    public int getSupportedFeatures() {
        return 8;
    }

    public String toString() {
        return this.getId();
    }

    public int getSVNAPIVersion() {
        return 6;
    }

    protected static String checkLibraries() {
        try {
            if (!librariesLoaded) {
                if (FileUtility.isWindows()) {
                    System.loadLibrary("libdb44");
                    System.loadLibrary("intl3_svn");
                    System.loadLibrary("libapr-1");
                    System.loadLibrary("libapriconv-1");
                    System.loadLibrary("libaprutil-1");
                    System.loadLibrary("libeay32");
                    System.loadLibrary("ssleay32");
                    System.loadLibrary("dbghelp");
                    System.loadLibrary("libsvn_subr-1");
                    System.loadLibrary("libsvn_delta-1");
                    System.loadLibrary("libsvn_fs-1");
                    System.loadLibrary("libsvn_repos-1");
                    System.loadLibrary("libsvn_diff-1");
                    System.loadLibrary("libsvn_wc-1");
                    System.loadLibrary("libsasl");
                    System.loadLibrary("libsvn_ra-1");
                    System.loadLibrary("libsvn_client-1");
                }
                UnsatisfiedLinkError err = null;
                try {
                    System.loadLibrary("svnjavahl-1");
                }
                catch (UnsatisfiedLinkError e1) {
                    err = e1;
                    try {
                        System.loadLibrary("libsvnjavahl-1");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        try {
                            System.loadLibrary("svnjavahl");
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                            throw err;
                        }
                    }
                }
                SVNClient.version();
                librariesLoaded = true;
            }
            return null;
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                return JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries0", new String[]{ConversionUtility.convertZeroCodedLine(ex.getMessage())});
            }
            return JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries1");
        }
    }
}

