/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.svnkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.polarion.team.svn.connector.svnkit.SVNKitConnector;
import org.polarion.team.svn.connector.svnkit.SVNKitPlugin;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class SVNKitConnectorFactory
implements ISVNConnectorFactory {
    public static final String CLIENT_ID = "org.eclipse.team.svn.connector.svnkit15";

    public ISVNConnector newInstance() {
        return new SVNKitConnector();
    }

    public String getName() {
        String format = "%1$s %2$s r%3$s (SVN %4$s compatible, all platforms)";
        String fullClientVersion = this.getClientVersion();
        String versionRegex = "\\d+\\.\\d+\\.\\d+.*";
        Pattern regex = Pattern.compile("^SVN/(" + versionRegex + ")\\s+SVNKit/(" + versionRegex + ")\\s+\\(http://svnkit.com/\\)\\s+r\\d+$");
        Matcher matcher = regex.matcher(fullClientVersion);
        if (matcher.matches()) {
            String svnVersion = matcher.group(1);
            String clientVersion = matcher.group(2);
            return String.format(format, SVNKitPlugin.instance().getResource("ClientName"), clientVersion, SVNClientImpl.versionRevisionNumber(), svnVersion);
        }
        return SVNKitPlugin.instance().getResource("ClientName");
    }

    public String getId() {
        return CLIENT_ID;
    }

    public String getClientVersion() {
        return SVNClientImpl.version();
    }

    public String getVersion() {
        return SVNKitPlugin.instance().getVersionString();
    }

    public String getCompatibilityVersion() {
        return "0.7.9.I20110318-1700";
    }

    public int getSupportedFeatures() {
        return 7;
    }

    public int getSVNAPIVersion() {
        return 5;
    }

    public String toString() {
        return this.getId();
    }
}

