/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.connector.javahl.JavaHLConnector;
import org.polarion.team.svn.connector.javahl.JavaHLPlugin;
import org.tigris.subversion.javahl.ConversionUtility;
import org.tigris.subversion.javahl.SVNClient;

public class JavaHLConnectorFactory
implements ISVNConnectorFactory {
    public static final String CLIENT_ID = "org.eclipse.team.svn.connector.javahl16";
    private static boolean librariesLoaded = false;

    public ISVNConnector newInstance() {
        String error = JavaHLConnectorFactory.checkLibraries();
        if (error != null) {
            throw new RuntimeException(error);
        }
        return new JavaHLConnector();
    }

    public String getName() {
        String format = "%1$s %2$s r%3$s (SVN %4$s)";
        String fullClientVersion = this.getClientVersion();
        Pattern regex = Pattern.compile("^svn:(\\d+\\.\\d+\\.\\d+.*)\\s+\\(r(\\d+)\\)\njni:\\d+\\.\\d+\\.\\d+$");
        Matcher matcher = regex.matcher(fullClientVersion);
        if (matcher.matches()) {
            String version = matcher.group(1);
            String revision = matcher.group(2);
            return String.format(format, JavaHLPlugin.instance().getResource("ClientName"), version, revision, version);
        }
        return String.valueOf(JavaHLPlugin.instance().getResource("ClientName")) + " " + fullClientVersion;
    }

    public String getId() {
        return CLIENT_ID;
    }

    public String getClientVersion() {
        String error = JavaHLConnectorFactory.checkLibraries();
        if (error != null) {
            return error;
        }
        return SVNClient.version();
    }

    public String getVersion() {
        return JavaHLPlugin.instance().getVersionString();
    }

    public String getCompatibilityVersion() {
        return "0.7.9.I20110318-1700";
    }

    public int getSupportedFeatures() {
        return 24;
    }

    public String toString() {
        return this.getId();
    }

    public int getSVNAPIVersion() {
        return 6;
    }

    protected static String checkLibraries() {
        try {
            if (!librariesLoaded) {
                if (FileUtility.isWindows() && System.getProperty("subversion.native.library") == null) {
                    JavaHLConnectorFactory.windowsLibraryLoadHelper(null, new String[]{"libapr-1", "libapriconv-1", "libaprutil-1", "libeay32", "ssleay32", "dbghelp", "libsvn_subr-1", "libsvn_delta-1", "libsvn_fs-1", "libsvn_repos-1", "libsvn_diff-1", "libsvn_wc-1", "libsasl", "libsvn_ra-1", "libsvn_client-1"});
                }
                SVNClient.version();
                librariesLoaded = true;
            }
            return null;
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                return JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries0", new String[]{ConversionUtility.convertZeroCodedLine(ex.getMessage())});
            }
            return JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries1");
        }
    }

    public static void windowsLibraryLoadHelper(String path, String[] dependencies) {
        String[] stringArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String dependency = stringArray[n2];
            if (path == null) {
                System.loadLibrary(dependency);
            } else {
                System.load(String.valueOf(path) + "/" + dependency + ".dll");
            }
            ++n2;
        }
    }
}

