/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.tigris.subversion.javahl.BlameCallback2;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.ConflictResult;
import org.tigris.subversion.javahl.ConflictVersion;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.ProplistCallback;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;

public final class ConversionUtility {
    public static ProplistCallback convert(final ISVNPropertyCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ProplistCallback(){

            public void singlePath(String path, Map properties) {
                SVNProperty[] data = new SVNProperty[properties.size()];
                int i = 0;
                for (Map.Entry entry : properties.entrySet()) {
                    data[i] = new SVNProperty((String)entry.getKey(), (String)entry.getValue());
                    ++i;
                }
                callback.next(path, data);
            }
        };
    }

    public static Map convert(Map revProps) {
        if (revProps == null) {
            return null;
        }
        HashMap retVal = new HashMap();
        if (revProps.containsKey("svn:author")) {
            retVal.put("svn:author", revProps.get("svn:author"));
        }
        if (revProps.containsKey("svn:log")) {
            retVal.put("svn:log", revProps.get("svn:log"));
        }
        retVal.putAll(revProps);
        if (retVal.containsKey("svn:date")) {
            Date date = (Date)revProps.get("svn:date");
            retVal.put("svn:date", date == null ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z").format(date));
        }
        return retVal;
    }

    public static LogMessageCallback convert(final ISVNLogEntryCallback callback) {
        if (callback == null) {
            return null;
        }
        return new LogMessageCallback(){
            private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            private Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

            public void singleMessage(ChangePath[] changedPaths, long revision, Map revProps, boolean hasChildren) {
                SVNLogEntry entry = this.convert(changedPaths, revision, revProps, hasChildren);
                callback.next(entry);
            }

            private SVNLogEntry convert(ChangePath[] changedPaths, long revision, Map revProps, boolean hasChildren) {
                if (revProps == null) {
                    return new SVNLogEntry(revision, 0L, null, null, ConversionUtility.convert(changedPaths), hasChildren);
                }
                String dateStr = (String)revProps.get("svn:date");
                long date = 0L;
                if (dateStr != null && dateStr.length() == 27 && dateStr.charAt(26) == 'Z') {
                    try {
                        this.date.setTime(this.formatter.parse(String.valueOf(dateStr.substring(0, 23)) + " UTC"));
                        date = this.date.getTimeInMillis();
                    }
                    catch (ParseException parseException) {
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return new SVNLogEntry(revision, date, (String)revProps.get("svn:author"), (String)revProps.get("svn:log"), ConversionUtility.convert(changedPaths), hasChildren);
            }
        };
    }

    public static CopySource[] convert(SVNEntryRevisionReference[] info) {
        if (info == null) {
            return null;
        }
        CopySource[] retVal = new CopySource[info.length];
        int i = 0;
        while (i < info.length) {
            retVal[i] = ConversionUtility.convert(info[i]);
            ++i;
        }
        return retVal;
    }

    public static CopySource convert(SVNEntryRevisionReference info) {
        return info == null ? null : new CopySource(info.path, ConversionUtility.convert(info.revision), ConversionUtility.convert(info.pegRevision));
    }

    public static InfoCallback convert(final ISVNEntryInfoCallback callback) {
        if (callback == null) {
            return null;
        }
        return new InfoCallback(){

            public void singleInfo(Info2 info) {
                callback.next(ConversionUtility.convert(info));
            }
        };
    }

    public static StatusCallback convert(final ISVNEntryStatusCallback cb) {
        return new StatusCallback(){

            public void doStatus(Status st) {
                cb.next(ConversionUtility.convert(st));
            }
        };
    }

    public static ConflictResolverCallback convert(final ISVNConflictResolutionCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ConflictResolverCallback(){

            public ConflictResult resolve(ConflictDescriptor descrip) throws SubversionException {
                try {
                    return ConversionUtility.convert(callback.resolve(ConversionUtility.convert(descrip)));
                }
                catch (SVNConnectorException ex) {
                    throw new SubversionException(ex.getMessage());
                }
            }
        };
    }

    public static SVNConflictDescriptor convert(ConflictDescriptor descr) {
        return descr == null ? null : new SVNConflictDescriptor(descr.getPath(), descr.getKind(), descr.getNodeKind(), descr.getPropertyName(), descr.isBinary(), descr.getMIMEType(), descr.getAction(), descr.getReason(), descr.getOperation(), descr.getBasePath(), descr.getTheirPath(), descr.getMyPath(), descr.getMergedPath(), ConversionUtility.convert(descr.getSrcLeftVersion()), ConversionUtility.convert(descr.getSrcRightVersion()));
    }

    public static SVNConflictVersion convert(ConflictVersion conflictVersion) {
        return conflictVersion == null ? null : new SVNConflictVersion(conflictVersion.getReposURL(), conflictVersion.getPegRevision(), conflictVersion.getPathInRepos(), conflictVersion.getNodeKind());
    }

    public static ConflictResult convert(SVNConflictResolution result) {
        return result == null ? null : new ConflictResult(result.choice, result.mergedPath);
    }

    public static SVNMergeInfo convert(Mergeinfo info) {
        if (info == null) {
            return null;
        }
        SVNMergeInfo retVal = new SVNMergeInfo();
        String[] paths = info.getPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                retVal.addRevisions(paths[i], ConversionUtility.convert(info.getRevisionRange(paths[i])));
                ++i;
            }
        }
        return retVal;
    }

    public static RevisionRange[] convert(SVNRevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        RevisionRange[] retVal = new RevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange[] convert(RevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        SVNRevisionRange[] retVal = new SVNRevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange convert(RevisionRange range) {
        return range == null ? null : new SVNRevisionRange(ConversionUtility.convert(range.getFromRevision()), ConversionUtility.convert(range.getToRevision()));
    }

    public static RevisionRange convert(SVNRevisionRange range) {
        return range == null ? null : new RevisionRange(ConversionUtility.convert(range.from), ConversionUtility.convert(range.to));
    }

    public static SVNEntryInfo[] convert(Info2[] infos) {
        if (infos == null) {
            return null;
        }
        SVNEntryInfo[] retVal = new SVNEntryInfo[infos.length];
        int i = 0;
        while (i < infos.length) {
            retVal[i] = ConversionUtility.convert(infos[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNEntryInfo convert(Info2 info) {
        return new SVNEntryInfo(info.getPath(), info.getUrl(), info.getRev(), info.getKind(), info.getReposRootUrl(), info.getReposUUID(), info.getLastChangedRev(), info.getLastChangedDate() == null ? 0L : info.getLastChangedDate().getTime(), info.getLastChangedAuthor(), ConversionUtility.convert(info.getLock()), info.isHasWcInfo(), info.getSchedule(), info.getCopyFromUrl(), info.getCopyFromRev(), info.getTextTime() == null ? 0L : info.getTextTime().getTime(), info.getPropTime() == null ? 0L : info.getPropTime().getTime(), info.getChecksum(), info.getConflictOld(), info.getConflictNew(), info.getConflictWrk(), info.getPrejfile(), info.getDepth(), ConversionUtility.convert(info.getConflictDescriptor()));
    }

    public static SVNLogPath[] convert(ChangePath[] paths) {
        if (paths == null) {
            return null;
        }
        SVNLogPath[] retVal = new SVNLogPath[paths.length];
        int i = 0;
        while (i < paths.length) {
            retVal[i] = ConversionUtility.convert(paths[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNLogPath convert(ChangePath path) {
        return new SVNLogPath(path.getPath(), path.getAction(), path.getCopySrcPath(), path.getCopySrcRevision());
    }

    public static SVNProperty[] convert(PropertyData[] data) {
        if (data == null) {
            return null;
        }
        SVNProperty[] retVal = new SVNProperty[data.length];
        int i = 0;
        while (i < data.length) {
            retVal[i] = ConversionUtility.convert(data[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNProperty convert(PropertyData data) {
        if (data == null) {
            return null;
        }
        String value = data.getValue() != null ? data.getValue() : (data.getData() != null ? new String(data.getData()) : null);
        return new SVNProperty(data.getName(), value);
    }

    public static SVNChangeStatus[] convert(Status[] st) {
        if (st == null) {
            return null;
        }
        SVNChangeStatus[] retVal = new SVNChangeStatus[st.length];
        int i = 0;
        while (i < st.length) {
            retVal[i] = ConversionUtility.convert(st[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus convert(Status st) {
        return new SVNChangeStatus(st.getPath(), st.getUrl(), st.getNodeKind(), st.getRevisionNumber(), st.getLastChangedRevisionNumber(), st.getLastChangedDate() == null ? 0L : st.getLastChangedDate().getTime(), st.getLastCommitAuthor(), st.getTextStatus(), st.getPropStatus(), st.getRepositoryTextStatus(), st.getRepositoryPropStatus(), st.isLocked(), st.isCopied(), st.getConflictOld(), st.getConflictNew(), st.getConflictWorking(), st.getUrlCopiedFrom(), st.getRevisionCopiedFromNumber(), st.isSwitched(), st.getLockToken(), st.getLockOwner(), st.getLockComment(), st.getLockCreationDate() == null ? 0L : st.getLockCreationDate().getTime(), ConversionUtility.convert(st.getReposLock()), st.getReposLastCmtRevisionNumber(), st.getReposLastCmtDate() == null ? 0L : st.getReposLastCmtDate().getTime(), st.getReposKind(), st.getReposLastCmtAuthor(), st.isFileExternal(), st.hasTreeConflict(), ConversionUtility.convert(st.getConflictDescriptor()));
    }

    public static SVNLock convert(Lock lock) {
        return lock == null ? null : new SVNLock(lock.getOwner(), lock.getPath(), lock.getToken(), lock.getComment(), lock.getCreationDate() == null ? 0L : lock.getCreationDate().getTime(), lock.getExpirationDate() == null ? 0L : lock.getExpirationDate().getTime());
    }

    public static BlameCallback2 convert(final ISVNAnnotationCallback cb) {
        return new BlameCallback2(){

            public void singleLine(Date date, long revision, String author, Date merged_date, long merged_revision, String merged_author, String merged_path, String line) {
                cb.annotate(line, new SVNAnnotationData(revision, date == null ? 0L : date.getTime(), author, merged_revision, merged_date == null ? 0L : merged_date.getTime(), merged_author, merged_path));
            }
        };
    }

    public static SVNRevision convert(Revision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case 5: {
                    return SVNRevision.BASE;
                }
                case 3: {
                    return SVNRevision.COMMITTED;
                }
                case 7: {
                    return SVNRevision.HEAD;
                }
                case 4: {
                    return SVNRevision.PREVIOUS;
                }
                case 6: {
                    return SVNRevision.WORKING;
                }
                case 0: {
                    return SVNRevision.START;
                }
                case 1: {
                    return SVNRevision.fromNumber((long)((Revision.Number)rev).getNumber());
                }
            }
            return SVNRevision.fromDate((long)((Revision.DateSpec)rev).getDate().getTime());
        }
        return null;
    }

    public static Revision convert(SVNRevision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case 5: {
                    return Revision.BASE;
                }
                case 3: {
                    return Revision.COMMITTED;
                }
                case 7: {
                    return Revision.HEAD;
                }
                case 4: {
                    return Revision.PREVIOUS;
                }
                case 6: {
                    return Revision.WORKING;
                }
                case 0: {
                    return Revision.START;
                }
                case 1: {
                    return Revision.getInstance(((SVNRevision.Number)rev).getNumber());
                }
            }
            return Revision.getInstance(new Date(((SVNRevision.Date)rev).getDate()));
        }
        return null;
    }

    public static SVNNotification convert(NotifyInformation info) {
        return new SVNNotification(info.getPath(), info.getAction(), info.getKind(), info.getMimeType(), ConversionUtility.convert(info.getLock()), info.getErrMsg(), info.getContentState(), info.getPropState(), info.getLockState(), info.getRevision());
    }

    public static ISVNNotificationCallback convert(Notify2 notify2) {
        return notify2 == null ? null : ((Notify2Wrapper)notify2).getNotify2();
    }

    public static Notify2 convert(ISVNNotificationCallback notify2) {
        return notify2 == null ? null : new Notify2Wrapper(notify2);
    }

    public static String convertZeroCodedLine(String source) {
        if (source != null) {
            byte[] data = new byte[source.length()];
            int i = 0;
            while (i < data.length) {
                data[i] = (byte)source.charAt(i);
                ++i;
            }
            source = new String(data);
        }
        return source;
    }

    private ConversionUtility() {
    }

    public static class Notify2Wrapper
    implements Notify2 {
        protected ISVNNotificationCallback notify;

        public Notify2Wrapper(ISVNNotificationCallback notify) {
            this.notify = notify;
        }

        public ISVNNotificationCallback getNotify2() {
            return this.notify;
        }

        public void onNotify(NotifyInformation info) {
            this.notify.notify(ConversionUtility.convert(info));
        }
    }
}

