/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetManager;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.ProjectCloseListener;
import org.eclipse.team.svn.ui.console.SVNConsole;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.update.UpdateSubscriber;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SVNTeamUIPlugin
extends AbstractUIPlugin {
    private static volatile SVNTeamUIPlugin instance = null;
    private ProjectCloseListener pcListener = new ProjectCloseListener();
    private URL baseUrl;
    private SVNConsole console;
    private SubscriberChangeSetManager changeSetManager;

    public SVNTeamUIPlugin() {
        instance = this;
    }

    public static SVNTeamUIPlugin instance() {
        return instance;
    }

    public IConsoleStream getConsoleStream() {
        return this.console == null ? null : this.console.getConsoleStream();
    }

    public String getResource(String key) {
        return FileUtility.getResource((ResourceBundle)Platform.getResourceBundle((Bundle)this.getBundle()), (String)key);
    }

    public String getResource(String key, Object[] args) {
        String message = this.getResource(key);
        return MessageFormat.format(message, args);
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.baseUrl, path));
        }
        catch (MalformedURLException e) {
            LoggedOperation.reportError((String)this.getResource("Error.GetImageDescriptor"), (Throwable)e);
            return null;
        }
    }

    public String getVersionString() {
        return (String)this.getBundle().getHeaders().get("Bundle-Version");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SVNTeamPreferences.setDefaultValues(this.getPreferenceStore());
        Preferences corePreferences = SVNTeamPlugin.instance().getPluginPreferences();
        String connector = corePreferences.getString("svnconnector").trim();
        if (connector.length() != 0) {
            SVNTeamPreferences.setCoreString(this.getPreferenceStore(), "svnconnector", connector);
            corePreferences.setValue("svnconnector", "");
            SVNTeamPlugin.instance().savePluginPreferences();
        }
        this.baseUrl = context.getBundle().getEntry("/");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.pcListener, 6);
        this.console = new SVNConsole();
    }

    public void stop(BundleContext context) throws Exception {
        this.console.shutdown();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        if (this.changeSetManager != null) {
            this.changeSetManager.dispose();
        }
        super.stop(context);
    }

    public synchronized SubscriberChangeSetManager getChangeSetManager() {
        if (this.changeSetManager == null) {
            this.changeSetManager = new SubscriberChangeSetManager((Subscriber)UpdateSubscriber.instance());
        }
        return this.changeSetManager;
    }
}

