/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.refactor.CopyResourceOperation;
import org.eclipse.team.svn.core.operation.local.refactor.CopyResourceWithHistoryOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractWorkingCopyAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.ContainerSelectionPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyAction
extends AbstractWorkingCopyAction {
    protected static final IStateFilter SF_EXCLUDE_DELETED_AND_PROJECTS = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            if (!IStateFilter.SF_LINKED.accept(resource, state, mask) && !IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask)) {
                return (resource instanceof IFolder || resource instanceof IFile) && state != "Deleted" && state != "Missing";
            }
            return false;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state != "Linked" && state != "Obstructed";
        }
    };

    @Override
    public void runImpl(IAction action) {
        IResource[] AllResources = this.getSelectedResources(SF_EXCLUDE_DELETED_AND_PROJECTS);
        HashMap<String, IResource> resourcesWithoutEqualsNames = new HashMap<String, IResource>();
        HashSet<String> conflictedResources = this.excludeResourcesWithEqualNames(resourcesWithoutEqualsNames, AllResources);
        if (resourcesWithoutEqualsNames.isEmpty()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), SVNTeamUIPlugin.instance().getResource("CopyAction.Conflict.Title"), null, SVNTeamUIPlugin.instance().getResource("CopyAction.Conflict.Message"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return;
        }
        IResource[] resources = resourcesWithoutEqualsNames.values().toArray(new IResource[resourcesWithoutEqualsNames.values().size()]);
        ContainerSelectionPanel panel = new ContainerSelectionPanel(resources, conflictedResources);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            IActionOperation copyOp;
            IPath path = panel.getSelectedPath();
            boolean saveHistory = panel.isCopyWithHistorySelected();
            CompositeOperation op = new CompositeOperation("Operation.CopyResources");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            AddToSVNOperation addOp = null;
            if (panel.isOverrideResourceName()) {
                String dirPath;
                Object destination;
                path = path.append(panel.getOverridenName());
                if (resources.length == 1) {
                    IResource[] parents;
                    destination = resources[0].getType() == 1 ? root.getFile(path) : root.getFolder(path);
                    dirPath = FileUtility.getWorkingCopyPath((IResource)destination.getParent());
                    if (dirPath != null) {
                        new File(dirPath).mkdirs();
                    }
                    boolean[] checkSave = new boolean[]{saveHistory};
                    copyOp = this.getCopyOperation(resources[0], checkSave, (IResource)destination);
                    if (checkSave[0] && (parents = FileUtility.getOperableParents((IResource[])new IResource[]{destination}, (IStateFilter)IStateFilter.SF_UNVERSIONED, (boolean)true)).length > 0) {
                        addOp = new AddToSVNOperation(parents);
                    }
                    if (addOp != null) {
                        op.add((IActionOperation)addOp);
                        op.add(copyOp, new IActionOperation[]{addOp});
                    } else {
                        op.add(copyOp);
                    }
                } else {
                    IResource[] parents;
                    destination = root.getFolder(path);
                    dirPath = FileUtility.getWorkingCopyPath((IResource)destination);
                    if (dirPath != null) {
                        new File(dirPath).mkdirs();
                    }
                    if ((parents = FileUtility.addOperableParents((IResource[])new IResource[]{destination}, (IStateFilter)IStateFilter.SF_UNVERSIONED, (boolean)true)).length > 0) {
                        addOp = new AddToSVNOperation(parents);
                        op.add((IActionOperation)addOp);
                    }
                }
            }
            if (resources.length > 1 || !panel.isOverrideResourceName()) {
                int i = 0;
                while (i < resources.length) {
                    IPath tPath = path.append(resources[i].getName());
                    IFile target = resources[i].getType() == 1 ? root.getFile(tPath) : root.getFolder(tPath);
                    copyOp = this.getCopyOperation(resources[i], new boolean[]{saveHistory}, (IResource)target);
                    if (addOp != null) {
                        op.add(copyOp, new IActionOperation[]{addOp});
                    } else {
                        op.add(copyOp);
                    }
                    ++i;
                }
            }
            op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{root.findMember(panel.getSelectedPath())}));
            this.runScheduled((IActionOperation)op);
        }
    }

    protected IActionOperation getCopyOperation(IResource resource, boolean[] saveHistory, IResource destination) {
        if (saveHistory[0]) {
            CopyResourceWithHistoryOperation copyOp = new CopyResourceWithHistoryOperation(resource, destination);
            if (copyOp.isAllowed()) {
                return copyOp;
            }
            saveHistory[0] = false;
        }
        return new CopyResourceOperation(resource, destination);
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(SF_EXCLUDE_DELETED_AND_PROJECTS);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected HashSet<String> excludeResourcesWithEqualNames(HashMap<String, IResource> map, IResource[] resources) {
        HashSet<String> conflicts = new HashSet<String>();
        int i = 0;
        while (i < resources.length) {
            if (map.containsKey(resources[i].getName())) {
                conflicts.add(resources[i].getName());
            } else {
                map.put(resources[i].getName(), resources[i]);
            }
            ++i;
        }
        for (String element : conflicts) {
            map.remove(element);
        }
        return conflicts;
    }
}

