/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.operation.local.property.SetMultiPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.properties.ResourcePropertyEditPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SetPropertyAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED);
        ResourcePropertyEditPanel panel = new ResourcePropertyEditPanel(null, resources, false);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            SetPropertyAction.doSetProperty(resources, panel, null);
        }
    }

    public static void doSetProperty(IResource[] resources, ResourcePropertyEditPanel panel, IActionOperation addOn) {
        SetPropertyAction.doSetProperty(resources, panel.getPropertyName(), panel.getPropertyValue(), panel.getPropertyFile(), panel.isFileSelected(), panel.isRecursiveSelected(), panel.getApplyMethod(), panel.useMask(), panel.getFilterMask(), panel.isStrict(), addOn);
    }

    public static void doSetProperty(IResource[] resources, String propertyName, String value, String fileName, boolean isFileSelected, boolean isRecursive, int applyMethod, boolean useMask, String filterMask, boolean strict, IActionOperation addOn) {
        final SVNProperty[] data = new SVNProperty[]{new SVNProperty(propertyName, value)};
        AbstractActionOperation loadOp = null;
        if (isFileSelected) {
            final File f = new File(fileName);
            loadOp = new AbstractActionOperation("Operation.SLoadFileContent"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(f);
                        byte[] binary = new byte[(int)f.length()];
                        input.read(binary);
                        data[0] = new SVNProperty(data[0].name, new String(binary));
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
            };
        }
        SetPropertyAction.doSetProperty(resources, data, loadOp, isRecursive, applyMethod, useMask, filterMask, strict, addOn);
    }

    public static void doSetProperty(IResource[] resources, final SVNProperty[] data, IActionOperation loadOp, boolean isRecursive, final int applyMethod, boolean useMask, String filterMask, boolean strict, IActionOperation addOn) {
        SetPropertiesOperation mainOp;
        final StringMatcher matcher = useMask ? new StringMatcher(filterMask) : null;
        IStateFilter.AbstractStateFilter filter = new IStateFilter.AbstractStateFilter(){

            protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                return IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.allowsRecursion(resource, state, mask) || state == "Added";
            }

            protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                return !(applyMethod == 1 && resource.getType() != 1 || applyMethod == 2 && resource.getType() == 1 || !IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.accept(resource, state, mask)) && (matcher == null || matcher.match(resource.getName()));
            }
        };
        if (!isRecursive || applyMethod == 0 && !useMask) {
            mainOp = new SetPropertiesOperation(FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)filter, (int)0), data, isRecursive & !strict);
        } else {
            IPropertyProvider propertyProvider = new IPropertyProvider(){

                public SVNProperty[] getProperties(IResource resource) {
                    return data;
                }
            };
            mainOp = new SetMultiPropertiesOperation(resources, propertyProvider, (IStateFilter)filter, isRecursive && !strict ? 2 : 0);
        }
        CompositeOperation composite = new CompositeOperation(mainOp.getId());
        if (loadOp != null) {
            composite.add(loadOp);
            composite.add((IActionOperation)mainOp, new IActionOperation[]{loadOp});
        } else {
            composite.add((IActionOperation)mainOp);
        }
        if (addOn != null) {
            composite.add(addOn);
        }
        composite.add((IActionOperation)new RefreshResourcesOperation(resources, 2, RefreshResourcesOperation.REFRESH_ALL), new IActionOperation[]{mainOp});
        UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)composite);
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED);
    }
}

