/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote.management;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.management.FindRelatedProjectsOperation;
import org.eclipse.team.svn.core.operation.local.management.RelocateWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.action.AbstractRepositoryModifyWorkspaceAction;
import org.eclipse.team.svn.ui.wizard.NewRepositoryLocationWizard;

public class EditRepositoryLocationPropertiesAction
extends AbstractRepositoryModifyWorkspaceAction {
    public void runImpl(IAction action) {
        final IRepositoryLocation[] locations = this.getSelectedRepositoryLocations();
        String oldRootUrl = locations[0].getRepositoryRootUrl();
        final IRepositoryLocation backup = SVNRemoteStorage.instance().newRepositoryLocation();
        SVNRemoteStorage.instance().copyRepositoryLocation(backup, locations[0]);
        NewRepositoryLocationWizard wizard = new NewRepositoryLocationWizard(locations[0], false);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            if (!locations[0].getUrl().startsWith(oldRootUrl)) {
                FindRelatedProjectsOperation scannerOp = new FindRelatedProjectsOperation(locations[0]);
                final RelocateWorkingCopyOperation mainOp = new RelocateWorkingCopyOperation((IResourceProvider)scannerOp, locations[0]);
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                op.add((IActionOperation)scannerOp);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new AbstractActionOperation("Operation.CheckRelocationState"){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        if (mainOp.getExecutionState() != 0) {
                            SVNRemoteStorage.instance().copyRepositoryLocation(locations[0], backup);
                        }
                    }
                });
                op.add(wizard.getOperationToPerform());
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
                this.runScheduled((IActionOperation)op);
            } else {
                CompositeOperation op = (CompositeOperation)wizard.getOperationToPerform();
                FindRelatedProjectsOperation findOp = new FindRelatedProjectsOperation(locations[0]);
                op.add((IActionOperation)findOp);
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)findOp, 0, RefreshResourcesOperation.REFRESH_CACHE));
                this.runScheduled((IActionOperation)op);
            }
        }
    }

    public boolean isEnabled() {
        return this.getSelectedRepositoryLocations().length == 1;
    }
}

