/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryResource;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.compare.PropertyComparePanel;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.eclipse.team.svn.ui.compare.TwoWayPropertyCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoWayResourceCompareInput
extends ResourceCompareInput {
    protected SVNDiffStatus[] statuses;

    public TwoWayResourceCompareInput(CompareConfiguration configuration, IRepositoryResource next, IRepositoryResource prev, Collection<SVNDiffStatus> statuses) {
        super(configuration);
        this.rootLeft = SVNUtility.copyOf((IRepositoryResource)next);
        this.rootRight = SVNUtility.copyOf((IRepositoryResource)prev);
        this.statuses = statuses.toArray(new SVNDiffStatus[statuses.size()]);
    }

    @Override
    protected void fillMenu(IMenuManager manager, TreeSelection selection) {
        final CompareNode selectedNode = (CompareNode)((Object)selection.getFirstElement());
        Action tAction = null;
        tAction = new Action(SVNTeamUIPlugin.instance().getResource("SynchronizeActionGroup.CompareProperties")){

            public void run() {
                SVNRepositoryResource repoResource = (SVNRepositoryResource)((ResourceCompareInput.ResourceElement)selectedNode.getLeft()).getRepositoryResource();
                SVNEntryRevisionReference leftReference = new SVNEntryRevisionReference(repoResource.getUrl(), repoResource.getPegRevision(), repoResource.getSelectedRevision());
                repoResource = (SVNRepositoryResource)((ResourceCompareInput.ResourceElement)selectedNode.getRight()).getRepositoryResource();
                SVNEntryRevisionReference rightReference = new SVNEntryRevisionReference(repoResource.getUrl(), repoResource.getPegRevision(), repoResource.getSelectedRevision());
                TwoWayPropertyCompareInput input = new TwoWayPropertyCompareInput(new CompareConfiguration(), leftReference, rightReference, repoResource.getRepositoryLocation());
                try {
                    input.run((IProgressMonitor)new NullProgressMonitor());
                    if (input.getCompareResult() == null) {
                        MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), SVNTeamUIPlugin.instance().getResource("ComparePropsNoDiff.Title"), null, SVNTeamUIPlugin.instance().getResource("ComparePropsNoDiff.Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                    } else {
                        PropertyComparePanel panel = new PropertyComparePanel(input, false);
                        DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                        dlg.open();
                    }
                }
                catch (Exception ex) {
                    UILoggedOperation.reportError("Compare Properties Operation", ex);
                }
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(selection.size() == 1 && (selectedNode.getKind() & 3) != 1 && (selectedNode.getKind() & 3) != 2);
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws Exception {
        SVNUtility.reorder((SVNDiffStatus[])this.statuses, (boolean)true);
        HashMap<IPath, IDiffElement> path2node = new HashMap<IPath, IDiffElement>();
        String message = SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.CheckingDelta");
        int i = 0;
        while (i < this.statuses.length) {
            monitor.subTask(MessageFormat.format(message, SVNUtility.decodeURL((String)this.statuses[i].pathPrev)));
            CompareNode node = this.makeNode(this.statuses[i], path2node, monitor);
            path2node.put((IPath)new Path(((ResourceCompareInput.ResourceElement)node.getRight()).getRepositoryResource().getUrl()), (IDiffElement)node);
            ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)this.statuses.length);
            ++i;
        }
        this.findRootNode(path2node, this.rootRight, monitor);
        if (this.root == null) {
            this.findRootNode(path2node, this.rootLeft, monitor);
        }
        super.initialize(monitor);
    }

    protected CompareNode makeNode(SVNDiffStatus st, Map path2node, IProgressMonitor monitor) throws Exception {
        String urlNext = SVNUtility.decodeURL((String)st.pathNext);
        String urlPrev = SVNUtility.decodeURL((String)st.pathPrev);
        int nodeKind = this.getNodeKind(st);
        IRepositoryResource next = this.createResourceFor(this.rootLeft.getRepositoryLocation(), nodeKind, urlNext);
        next.setSelectedRevision(this.rootLeft.getSelectedRevision());
        next.setPegRevision(this.rootLeft.getPegRevision());
        IRepositoryResource prev = this.createResourceFor(this.rootRight.getRepositoryLocation(), nodeKind, urlPrev);
        prev.setSelectedRevision(this.rootRight.getSelectedRevision());
        prev.setPegRevision(this.rootRight.getPegRevision());
        IDiffContainer parent = this.getParentCompareNode(prev, path2node);
        int diffKind = ResourceCompareInput.getDiffKind(st.textStatus, st.propStatus);
        diffKind = diffKind == 2 ? 1 : (diffKind == 1 ? 2 : diffKind);
        return new CompareNode(parent, diffKind, next, prev, st.textStatus == 1 ? st.propStatus : st.textStatus);
    }

    @Override
    protected IDiffContainer makeStubNode(IDiffContainer parent, IRepositoryResource node) {
        IRepositoryResource next = node;
        String prevUrl = node.getUrl();
        if (prevUrl.length() > this.rootRight.getUrl().length()) {
            String urlPart = prevUrl.substring(this.rootRight.getUrl().length());
            String urlNext = String.valueOf(this.rootLeft.getUrl()) + urlPart;
            next = this.createResourceFor(this.rootLeft.getRepositoryLocation(), node instanceof IRepositoryFile ? 1 : 2, urlNext);
            next.setSelectedRevision(this.rootLeft.getSelectedRevision());
            next.setPegRevision(this.rootLeft.getPegRevision());
        }
        return new CompareNode(parent, 0, next, node, 1);
    }

    @Override
    protected boolean isThreeWay() {
        return false;
    }

    @Override
    protected ResourceCompareInput.ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareInput.ResourceCompareViewer(this, parent, config){

            public void setLabelProvider(IBaseLabelProvider labelProvider) {
                super.setLabelProvider((IBaseLabelProvider)new ResourceCompareInput.ResourceCompareViewer.LabelProviderWrapper(this, (ILabelProvider)labelProvider){

                    public Image getImage(Object element) {
                        if (element instanceof CompareNode && ((CompareNode)((Object)element)).getChangeType() == 7) {
                            Image image = (Image)this.images.get(element);
                            if (image == null) {
                                OverlayedImageDescriptor imageDescriptor = new OverlayedImageDescriptor(this.baseProvider.getImage(element), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_2way.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                                image = imageDescriptor.createImage();
                                this.images.put(element, image);
                            }
                            return image;
                        }
                        return super.getImage(element);
                    }
                });
            }
        };
    }

    protected class CompareNode
    extends ResourceCompareInput.BaseCompareNode {
        protected int changeType;

        public CompareNode(IDiffContainer parent, int kind, IRepositoryResource next, IRepositoryResource prev, int changeType) {
            super(parent, kind);
            this.changeType = changeType;
            this.setRight(new ResourceCompareInput.ResourceElement(prev, null, changeType != 3));
            this.setLeft(new ResourceCompareInput.ResourceElement(next, null, changeType != 4));
        }

        public int getChangeType() {
            return this.changeType;
        }
    }
}

