/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.decorator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.decorator.AbstractResourceDecorator;
import org.eclipse.team.svn.ui.decorator.wrapper.AbstractDecoratorWrapper;
import org.eclipse.team.svn.ui.decorator.wrapper.WorkingSetDecoratorWrapper;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class WorkingSetDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    protected boolean useFonts;
    protected IPropertyChangeListener configurationListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().startsWith("preference.decoration.") || event.getProperty().startsWith("preference.dateFormat.")) {
                WorkingSetDecorator.this.loadConfiguration();
                String decoratorId = WorkingSetDecoratorWrapper.class.getName();
                SVNTeamUIPlugin.instance().getWorkbench().getDecoratorManager().update(decoratorId);
            }
        }
    };
    protected Color changedForegroundColor;
    protected Color changedBackgroundColor;
    protected Font changedFont;

    public WorkingSetDecorator() {
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener(this.configurationListener);
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        super.dispose();
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            if (element instanceof IWorkingSet) {
                boolean svnSharedPresents = false;
                boolean hasOutgoingChanges = false;
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                IAdaptable[] adaptables = ((IWorkingSet)element).getElements();
                int i = 0;
                while (i < adaptables.length) {
                    IProject project = (IProject)adaptables[i].getAdapter(IProject.class);
                    if (AbstractDecoratorWrapper.isSVNShared((IResource)project)) {
                        svnSharedPresents = true;
                        if (FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{project}, (IStateFilter)IStateFilter.SF_ANY_CHANGE)) {
                            hasOutgoingChanges = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (svnSharedPresents) {
                    boolean addVersioned = false;
                    if (SVNTeamPreferences.getDecorationBoolean(store, "icon.remote")) {
                        addVersioned = true;
                    }
                    if (hasOutgoingChanges) {
                        if (this.changedFont == null) {
                            this.loadConfiguration();
                        }
                        decoration.addPrefix(String.valueOf(SVNTeamPreferences.getDecorationString(store, "flag.outgoing")) + " ");
                        if (this.useFonts) {
                            decoration.setBackgroundColor(this.changedBackgroundColor);
                            decoration.setForegroundColor(this.changedForegroundColor);
                            decoration.setFont(this.changedFont);
                        }
                        if (SVNTeamPreferences.getDecorationBoolean(store, "icon.modified")) {
                            decoration.addOverlay(AbstractResourceDecorator.OVR_MODIFIED);
                            addVersioned = false;
                        }
                    }
                    if (addVersioned) {
                        decoration.addOverlay(AbstractResourceDecorator.OVR_VERSIONED);
                    }
                }
            }
        }
        catch (Throwable throwable) {}
    }

    protected void loadConfiguration() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.useFonts = SVNTeamPreferences.getDecorationBoolean(store, "use.fontdecor");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                WorkingSetDecorator.this.changedFont = current.getFontRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_font"));
                WorkingSetDecorator.this.changedForegroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_foreground_color"));
                WorkingSetDecorator.this.changedBackgroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_background_color"));
            }
        });
    }
}

