/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.eclipse.team.svn.ui.compare.TwoWayResourceCompareInput;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CompareRepositoryResourcesOperation
extends AbstractActionOperation {
    protected IRepositoryResource next;
    protected IRepositoryResource prev;
    protected IRepositoryResourceProvider provider;
    protected boolean forceReuse;
    protected String forceId;

    public CompareRepositoryResourcesOperation(IRepositoryResource prev, IRepositoryResource next) {
        this(prev, next, false);
    }

    public CompareRepositoryResourcesOperation(IRepositoryResource prev, IRepositoryResource next, boolean forceReuse) {
        super("Operation.CompareRepository");
        this.prev = prev;
        this.next = next;
        this.forceReuse = forceReuse;
    }

    public CompareRepositoryResourcesOperation(IRepositoryResourceProvider provider) {
        this(null, null, false);
        this.provider = provider;
    }

    public CompareRepositoryResourcesOperation(IRepositoryResourceProvider provider, boolean forceReuse) {
        this(null, null, forceReuse);
        this.provider = provider;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            IRepositoryResource[] toCompare = this.provider.getRepositoryResources();
            this.prev = toCompare[0];
            this.next = toCompare[1];
        }
        final LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{this.next, this.prev});
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
            }
        }, monitor, 100, 60);
        this.next = op.getRepositoryResources()[0];
        this.prev = op.getRepositoryResources()[1];
        IRepositoryLocation location = this.prev.getRepositoryLocation();
        final ISVNConnector proxy = location.acquireSVNProxy();
        final ArrayList statuses = new ArrayList();
        ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)SVNTeamPlugin.instance().getResource("Progress.Running"));
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                SVNEntryRevisionReference refNext;
                SVNEntryRevisionReference refPrev = SVNUtility.getEntryRevisionReference((IRepositoryResource)CompareRepositoryResourcesOperation.this.prev);
                if (SVNUtility.useSingleReferenceSignature((SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)(refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)CompareRepositoryResourcesOperation.this.next)))) {
                    SVNUtility.diffStatus((ISVNConnector)proxy, (Collection)statuses, (SVNEntryReference)refPrev, (SVNRevision)refPrev.revision, (SVNRevision)refNext.revision, (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareRepositoryResourcesOperation.this, monitor, null, false));
                } else {
                    SVNUtility.diffStatus((ISVNConnector)proxy, (Collection)statuses, (SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)refNext, (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareRepositoryResourcesOperation.this, monitor, null, false));
                }
            }
        }, monitor, 100, 20);
        location.releaseSVNProxy(proxy);
        if (!monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.FALSE);
                    final TwoWayResourceCompareInput compare = new TwoWayResourceCompareInput(cc, CompareRepositoryResourcesOperation.this.next, CompareRepositoryResourcesOperation.this.prev, statuses);
                    compare.setForceId(CompareRepositoryResourcesOperation.this.forceId);
                    compare.initialize(monitor);
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            ResourceCompareInput.openCompareEditor(compare, (this).CompareRepositoryResourcesOperation.this.forceReuse);
                        }
                    });
                }
            }, monitor, 100, 20);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.next.getName(), this.prev.getName());
    }
}

