/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class FileToClipboardOperation
extends AbstractActionOperation {
    protected String fileName;
    protected boolean deleteFile;

    public FileToClipboardOperation(String fileName) {
        this(fileName, true);
    }

    public FileToClipboardOperation(String fileName, boolean deleteFile) {
        super("Operation.FileToClipboard");
        this.fileName = fileName;
        this.deleteFile = deleteFile;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ByteArrayOutputStream data = new ByteArrayOutputStream();
        File tempFile = new File(this.fileName);
        FileInputStream stream = new FileInputStream(tempFile);
        try {
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = stream.read(buf)) > 0) {
                data.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
        if (this.deleteFile) {
            tempFile.delete();
        }
        if (data.size() > 0) {
            final Display display = UIMonitorUtility.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    TextTransfer plainTextTransfer = TextTransfer.getInstance();
                    Clipboard clipboard = new Clipboard(display);
                    clipboard.setContents((Object[])new String[]{data.toString()}, new Transfer[]{plainTextTransfer});
                    clipboard.dispose();
                }
            });
        }
    }
}

