/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SpellcheckedTextProvider;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPropsPreferencePage;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.PropertyNameVerifier;

public class EditCustomPropertiesPanel
extends AbstractDialogPanel {
    protected SVNTeamPropsPreferencePage.CustomProperty property;
    protected Text propName;
    protected Text propRegexp;
    protected StyledText propDescription;

    public EditCustomPropertiesPanel(SVNTeamPropsPreferencePage.CustomProperty property) {
        this.property = property;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource(property == null ? "EditCustomPropertiesPanel.Title.Add" : "EditAutoPropertiesPanel.Title.Edit");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Message");
    }

    protected void createControlsImpl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        Label propNameLabel = new Label(parent, 0);
        propNameLabel.setText(SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropName"));
        this.propName = new Text(parent, 2048);
        this.propName.setText(this.property == null ? "" : this.property.propName);
        GridData layoutData = new GridData(768);
        this.propName.setLayoutData((Object)layoutData);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropName.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new PropertyNameVerifier(name));
        this.attachTo((Control)this.propName, verifier);
        Group optional = new Group(parent, 0);
        optional.setText(SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Optional"));
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        optional.setLayoutData((Object)layoutData);
        layout = new GridLayout();
        layout.numColumns = 1;
        optional.setLayout((Layout)layout);
        Label propRegexpLabel = new Label((Composite)optional, 0);
        propRegexpLabel.setText(SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropRegExp"));
        this.propRegexp = new Text((Composite)optional, 2048);
        this.propRegexp.setText(this.property == null ? "" : this.property.regExp);
        layoutData = new GridData(768);
        this.propRegexp.setLayoutData((Object)layoutData);
        this.attachTo((Control)this.propRegexp, new AbstractFormattedVerifier("EditCustomProperty.Regexp"){

            protected String getErrorMessageImpl(Control input) {
                try {
                    Pattern.compile(this.getText(input));
                }
                catch (Exception exception) {
                    return SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Validator.RegExp");
                }
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
        Label propDescriptionLabel = new Label((Composite)optional, 0);
        propDescriptionLabel.setText(SVNTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropDescription"));
        layoutData = new GridData();
        propDescriptionLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(1808);
        layoutData.heightHint = 80;
        layoutData.widthHint = 0;
        this.propDescription = SpellcheckedTextProvider.getTextWidget((Composite)optional, layoutData, 578);
        this.propDescription.setText(this.property == null ? "" : this.property.descriprion);
    }

    public SVNTeamPropsPreferencePage.CustomProperty getProperty() {
        return this.property;
    }

    protected void cancelChangesImpl() {
    }

    protected void saveChangesImpl() {
        if (this.property == null) {
            this.property = new SVNTeamPropsPreferencePage.CustomProperty(this.propName.getText(), this.propRegexp.getText(), this.propDescription.getText());
        } else {
            this.property.propName = this.propName.getText();
            this.property.regExp = this.propRegexp.getText();
            this.property.descriprion = this.propDescription.getText();
        }
    }
}

