/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.reporting;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.composite.ReportingComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.extension.factory.IReporter;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.reporting.PreviewReportPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ErrorCancelPanel
extends AbstractDialogPanel {
    protected static final int ERROR_PANEL_TYPE = 0;
    protected static final int CANCEL_PANEL_TYPE = 1;
    protected ReportingComposite reportingComposite;
    protected Text errorTextField;
    protected String optionName;
    protected String simpleMessage;
    protected String advancedMessage;
    protected int panelType;
    protected boolean sendMail;
    protected boolean isPluginError;
    protected IStatus errorStatus;
    protected String plugin;
    protected String originalReport;

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, boolean isPlugInError, String optionName) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, isPlugInError, optionName);
    }

    public ErrorCancelPanel(String title, String simpleMessage, String advancedMessage, boolean sendMail, String optionName) {
        this(1, 0, title, simpleMessage, advancedMessage, sendMail, false, optionName);
    }

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, boolean isPlugInError, String optionName, IStatus errorStatus, String plugin) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, isPlugInError, optionName);
        this.errorStatus = errorStatus;
        this.plugin = plugin;
        this.isPluginError = isPlugInError;
    }

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, boolean isPlugInError, String optionName, IStatus errorStatus, String plugin, String originalReport) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, isPlugInError, optionName);
        this.errorStatus = errorStatus;
        this.plugin = plugin;
        this.originalReport = originalReport;
    }

    protected ErrorCancelPanel(int panelType, int numberOfErrors, String title, String simpleMessage, String advancedMessage, boolean sendMail, boolean isPlugInError, String optionName) {
        String[] stringArray;
        if (sendMail) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.Send");
            stringArray = stringArray2;
            stringArray2[1] = SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.DontSend");
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = IDialogConstants.OK_LABEL;
        }
        super(stringArray);
        this.isPluginError = isPlugInError;
        this.panelType = panelType;
        this.sendMail = sendMail;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource(panelType == 0 ? "ErrorCancelPanel.Title.Failed" : "ErrorCancelPanel.Title.Cancelled");
        this.dialogDescription = title == null || title.length() == 0 ? SVNTeamUIPlugin.instance().getResource(panelType == 0 ? "ErrorCancelPanel.Description.Failed.Empty" : "ErrorCancelPanel.Description.Cancelled.Empty") : SVNTeamUIPlugin.instance().getResource(panelType == 0 ? "ErrorCancelPanel.Description.Failed" : "ErrorCancelPanel.Description.Cancelled", new String[]{title});
        this.defaultMessage = sendMail ? SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.Message.Send") : (panelType == 0 ? (numberOfErrors == 1 ? SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.Message.DontSend.Single") : SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.Message.DontSend.Multi", new String[]{String.valueOf(numberOfErrors)})) : SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.Message.DontSend"));
        this.simpleMessage = simpleMessage == null ? SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.NoInfo") : simpleMessage;
        this.advancedMessage = advancedMessage == null ? SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.NoAdvancedInfo") : advancedMessage;
        this.optionName = optionName;
    }

    public IReporter getReporter() {
        return this.reportingComposite == null ? ReportingComposite.getDefaultReporter(this.panelType == 0, this.errorStatus) : this.reportingComposite.getReporter();
    }

    public boolean doNotShowAgain() {
        return this.reportingComposite != null ? this.reportingComposite.isNotShowAgain() : false;
    }

    public void createControlsImpl(Composite parent) {
        GridData data = null;
        this.errorTextField = new Text(parent, 2818);
        data = new GridData(1808);
        data.heightHint = 100;
        this.errorTextField.setLayoutData((Object)data);
        this.errorTextField.setEditable(false);
        this.errorTextField.setText(String.valueOf(this.simpleMessage) + "\n" + this.advancedMessage);
        if (this.sendMail) {
            Composite mailComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 1;
            mailComposite.setLayout((Layout)layout);
            data = new GridData(768);
            mailComposite.setLayoutData((Object)data);
            this.reportingComposite = new ReportingComposite(parent, this.dialogTitle, this.plugin, this.errorStatus, this.optionName, true, this, true);
            data = new GridData(768);
            this.reportingComposite.setLayoutData(data);
        } else if (this.originalReport != null) {
            Button viewButton = new Button(parent, 8);
            viewButton.setText(SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.OriginalReport"));
            data = new GridData();
            data.widthHint = DefaultDialog.computeButtonWidth(viewButton);
            viewButton.setLayoutData((Object)data);
            viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewReportPanel panel = new PreviewReportPanel(SVNTeamUIPlugin.instance().getResource("ErrorCancelPanel.OriginalReportPreview"), ErrorCancelPanel.this.originalReport);
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
                    dialog.open();
                }
            });
        }
    }

    public String getHelpId() {
        if (this.sendMail) {
            return "org.eclipse.team.svn.help.errorDialogContext";
        }
        return "org.eclipse.team.svn.help.cancelDialogContext";
    }

    protected void saveChangesImpl() {
        if (this.sendMail) {
            this.reportingComposite.saveChanges();
        }
    }

    protected void cancelChangesImpl() {
        if (this.sendMail) {
            this.reportingComposite.cancelChanges();
        }
    }

    protected void showDetails() {
    }

    public void postInit() {
        this.validateContent();
    }

    public Point getPrefferedSizeImpl() {
        return new Point(640, -1);
    }

    public String getImagePath() {
        return "icons/dialogs/" + (this.panelType == 0 && this.isPluginError ? "operation_error.gif" : "select_revision.gif");
    }
}

