/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ScopableSubscriberParticipant;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSVNParticipant
extends ScopableSubscriberParticipant
implements IChangeSetProvider {
    protected static ImageDescriptor OVR_OBSTRUCTED;
    protected static ImageDescriptor OVR_REPLACED_OUT;
    protected static ImageDescriptor OVR_REPLACED_IN;
    protected static ImageDescriptor OVR_REPLACED_CONF;
    protected static ImageDescriptor OVR_PROPCHANGE;
    protected ISynchronizePageConfiguration configuration;
    private ChangeSetCapability capability;

    public AbstractSVNParticipant() {
        this.setDefaults();
    }

    public AbstractSVNParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber(this.getMatchingSubscriber());
        this.setDefaults();
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber(this.getMatchingSubscriber());
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNChangeSetCapability();
        }
        return this.capability;
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(this.getParticipantId());
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        this.configuration = configuration;
        Collection<AbstractSynchronizeActionGroup> actionGroups = this.getActionGroups();
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            actionGroup.configureMenuGroups(configuration);
        }
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            configuration.addActionContribution((SynchronizePageActionGroup)actionGroup);
        }
        configuration.addLabelDecorator(this.createLabelDecorator());
        configuration.setSupportedModes(this.getSupportedModes());
        configuration.setMode(this.getDefaultMode());
    }

    protected ILabelDecorator createLabelDecorator() {
        return new LabelDecorator();
    }

    private void setDefaults() {
        if (OVR_REPLACED_OUT == null) {
            SVNTeamUIPlugin instance = SVNTeamUIPlugin.instance();
            OVR_OBSTRUCTED = instance.getImageDescriptor("icons/overlays/obstructed.gif");
            OVR_REPLACED_OUT = instance.getImageDescriptor("icons/overlays/replaced_out.gif");
            OVR_REPLACED_IN = instance.getImageDescriptor("icons/overlays/replaced_in.gif");
            OVR_REPLACED_CONF = instance.getImageDescriptor("icons/overlays/replaced_conf.gif");
            OVR_PROPCHANGE = instance.getImageDescriptor("icons/overlays/prop_changed.png");
        }
    }

    public abstract AbstractSVNSubscriber getMatchingSubscriber();

    protected abstract String getParticipantId();

    protected abstract Collection<AbstractSynchronizeActionGroup> getActionGroups();

    protected abstract int getSupportedModes();

    protected abstract int getDefaultMode();

    protected class LabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        public static final int CONFLICTING_REPLACEMENT_MASK = 15;
        public static final int REPLACEMENT_MASK = 3;
        protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

        public Image decorateImage(Image image, Object element) {
            AbstractSVNSyncInfo info = this.getSyncInfo(element);
            if (info != null) {
                ILocalResource left = info.getLocalResource();
                ILocalResource right = ((ResourceVariant)info.getRemote()).getResource();
                OverlayedImageDescriptor imgDescr = null;
                if (IStateFilter.SF_OBSTRUCTED.accept(left)) {
                    imgDescr = new OverlayedImageDescriptor(image, OVR_OBSTRUCTED, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                } else if ((info.getKind() & 0xF) == 15) {
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left) || IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    }
                } else if ((info.getKind() & 3) == 3) {
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left)) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_OUT, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    } else if (IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_IN, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    }
                }
                Image tmp = this.registerImageDescriptor(imgDescr);
                if (!(left.getResource() instanceof IContainer || (left.getChangeMask() & 2) == 0 && (right.getChangeMask() & 2) == 0)) {
                    if (tmp != null) {
                        image = tmp;
                    }
                    imgDescr = new OverlayedImageDescriptor(image, OVR_PROPCHANGE, new Point(23, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.BOTTOM);
                    return this.registerImageDescriptor(imgDescr);
                }
                return tmp;
            }
            return null;
        }

        public String decorateText(String text, Object element) {
            ILocalResource remote;
            ResourceVariant variant;
            AbstractSVNSyncInfo info = this.getSyncInfo(element);
            if (info != null && (variant = (ResourceVariant)info.getRemote()) != null && (remote = variant.getResource()).getRevision() != -1L) {
                return String.valueOf(text) + " " + variant.getContentIdentifier();
            }
            return null;
        }

        protected Image registerImageDescriptor(OverlayedImageDescriptor imgDescr) {
            if (imgDescr != null) {
                Image img = this.images.get((Object)imgDescr);
                if (img == null) {
                    img = imgDescr.createImage();
                    this.images.put((ImageDescriptor)imgDescr, img);
                }
                return img;
            }
            return null;
        }

        public void dispose() {
            for (Image img : this.images.values()) {
                img.dispose();
            }
        }

        protected AbstractSVNSyncInfo getSyncInfo(Object element) {
            if (element instanceof SyncInfoModelElement) {
                return (AbstractSVNSyncInfo)((SyncInfoModelElement)element).getSyncInfo();
            }
            return null;
        }
    }
}

