/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.ExtractToOperationLocal;
import org.eclipse.team.svn.core.operation.local.FiniExtractLogOperation;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.operation.remote.ExtractToOperationRemote;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ExtractToAction
extends AbstractSynchronizeModelAction {
    public ExtractToAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 4, 12});
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        AbstractSVNSyncInfo[] infos = this.getSVNSyncInfos();
        int i = 0;
        while (i < infos.length) {
            if (SyncInfo.getDirection((int)infos[i].getKind()) == 12) {
                return false;
            }
            ++i;
        }
        return infos.length > 0;
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        DirectoryDialog fileDialog = new DirectoryDialog(configuration.getSite().getShell());
        fileDialog.setText(SVNTeamUIPlugin.instance().getResource("ExtractToAction.Select.Title"));
        fileDialog.setMessage(SVNTeamUIPlugin.instance().getResource("ExtractToAction.Select.Description"));
        String path = fileDialog.open();
        if (path == null) {
            return null;
        }
        IResource[] outgoingChanges = this.syncInfoSelector.getSelectedResources(new ISyncStateFilter.StateFilterWrapper((IStateFilter)new IStateFilter.OrStateFilter(new IStateFilter[]{IStateFilter.SF_COMMITABLE, IStateFilter.SF_NEW}), null, true));
        HashSet<IProject> outgoingResources = new HashSet<IProject>((Collection)Arrays.asList(outgoingChanges));
        IResource[] iResourceArray = outgoingChanges;
        int n = outgoingChanges.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            outgoingResources.add(current.getProject());
            ++n2;
        }
        outgoingChanges = outgoingResources.toArray(new IResource[outgoingResources.size()]);
        IResource[] incomingChanges = this.syncInfoSelector.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(null, IStateFilter.SF_ANY_CHANGE, true));
        HashSet<IProject> incomingWithProjects = new HashSet<IProject>((Collection)Arrays.asList(incomingChanges));
        IResource[] iResourceArray2 = incomingChanges;
        int n3 = incomingChanges.length;
        int n4 = 0;
        while (n4 < n3) {
            IResource current = iResourceArray2[n4];
            incomingWithProjects.add(current.getProject());
            ++n4;
        }
        incomingChanges = incomingWithProjects.toArray(new IResource[incomingWithProjects.size()]);
        HashSet deletionsOnly = new HashSet(Arrays.asList(this.syncInfoSelector.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(null, IStateFilter.SF_DELETED, false))));
        HashSet<IRepositoryResource> incomingResourcesToOperate = new HashSet<IRepositoryResource>();
        HashSet<String> markedForDelition = new HashSet<String>();
        HashMap<String, String> resource2project = new HashMap<String, String>();
        IResource[] iResourceArray3 = incomingChanges;
        int n5 = incomingChanges.length;
        int n6 = 0;
        while (n6 < n5) {
            IResource current = iResourceArray3[n6];
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(current);
            IRepositoryResource projectRemote = SVNRemoteStorage.instance().asRepositoryResource((IResource)current.getProject());
            if (current instanceof IProject) {
                resource2project.put(remote.getUrl(), current.getName());
            } else if (!new Path(projectRemote.getUrl()).isPrefixOf((IPath)new Path(remote.getUrl()))) {
                resource2project.put(remote.getUrl(), current.getFullPath().toString().substring(1));
            }
            incomingResourcesToOperate.add(remote);
            if (deletionsOnly.contains(current)) {
                markedForDelition.add(remote.getUrl());
            }
            ++n6;
        }
        CompositeOperation op = new CompositeOperation("Operation.ExtractTo");
        op.add((IActionOperation)new InitExtractLogOperation(path));
        op.add((IActionOperation)new ExtractToOperationLocal(outgoingChanges, path, true));
        op.add((IActionOperation)new ExtractToOperationRemote(incomingResourcesToOperate.toArray(new IRepositoryResource[incomingResourcesToOperate.size()]), markedForDelition, path, resource2project, true));
        op.add((IActionOperation)new FiniExtractLogOperation(path));
        return op;
    }
}

