/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.operation.ShowHistoryViewOperation;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.variant.RemoteResourceVariant;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ShowHistoryAction
extends AbstractSynchronizeModelAction {
    public ShowHistoryAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        if (selection.size() == 1) {
            AbstractSVNSyncInfo syncInfo;
            ILocalResource incoming;
            if (selection.getFirstElement() instanceof SyncInfoModelElement && (incoming = ((ResourceVariant)(syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo()).getRemote()).getResource()) instanceof IResourceChange) {
                return "Deleted" != incoming.getStatus();
            }
            if (selection.getFirstElement() instanceof ISynchronizeModelElement) {
                ISynchronizeModelElement element = (ISynchronizeModelElement)selection.getFirstElement();
                return IStateFilter.SF_ONREPOSITORY.accept(SVNRemoteStorage.instance().asLocalResource(element.getResource()));
            }
        }
        return false;
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        RemoteResourceVariant variant;
        AbstractSVNSyncInfo info = this.getSelectedSVNSyncInfo();
        if (info != null && (variant = (RemoteResourceVariant)info.getRemote()).getResource() instanceof IResourceChange) {
            return new ShowHistoryViewOperation(((IResourceChange)variant.getResource()).getOriginator(), 0, 0);
        }
        return new ShowHistoryViewOperation(this.getSelectedResource(), 0, 0);
    }
}

