/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNMergeInfo {
    private Map<String, List<SVNRevisionRange>> mergeSources = new HashMap<String, List<SVNRevisionRange>>();

    public void addRevisions(String mergeSrc, SVNRevisionRange[] ranges) {
        List<SVNRevisionRange> revisions = this.getRevisionList(mergeSrc);
        revisions.addAll((Collection<SVNRevisionRange>)Arrays.asList(ranges));
    }

    public void addRevisionRange(String mergeSrc, SVNRevisionRange range) {
        List<SVNRevisionRange> revisions = this.getRevisionList(mergeSrc);
        revisions.add(range);
    }

    public String[] getPaths() {
        Set<String> pathSet = this.mergeSources.keySet();
        return pathSet == null ? null : pathSet.toArray(new String[pathSet.size()]);
    }

    public SVNRevisionRange[] getRevisions(String mergeSrc) {
        List<SVNRevisionRange> revisions = this.mergeSources.get(mergeSrc);
        return revisions == null ? null : revisions.toArray(new SVNRevisionRange[revisions.size()]);
    }

    protected List<SVNRevisionRange> getRevisionList(String mergeSrc) {
        List<SVNRevisionRange> revisions = this.mergeSources.get(mergeSrc);
        if (revisions == null) {
            revisions = new ArrayList<SVNRevisionRange>();
            this.mergeSources.put(mergeSrc, revisions);
        }
        return revisions;
    }

    public class LogKind {
        public static final int ELIGIBLE = 0;
        public static final int MERGED = 1;
    }
}

