/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import org.eclipse.team.svn.core.connector.SVNLock;

public class SVNNotification {
    public final String path;
    public final int action;
    public final int kind;
    public final String mimeType;
    public final SVNLock lock;
    public final String errMsg;
    public final int contentState;
    public final int propState;
    public final long revision;
    public final int lockState;

    public SVNNotification(String path, int action, int kind, String mimeType, SVNLock lock, String errMsg, int contentState, int propState, int lockState, long revision) {
        this.path = path;
        this.action = action;
        this.kind = kind;
        this.mimeType = mimeType;
        this.lock = lock;
        this.errMsg = errMsg;
        this.contentState = contentState;
        this.propState = propState;
        this.revision = revision;
        this.lockState = lockState;
    }

    public class NodeLock {
        public static final int INAPPLICABLE = 0;
        public static final int UNKNOWN = 1;
        public static final int UNCHANGED = 2;
        public static final int LOCKED = 3;
        public static final int UNLOCKED = 4;
    }

    public static class NodeStatus {
        public static final int INAPPLICABLE = 0;
        public static final int UNKNOWN = 1;
        public static final int UNCHANGED = 2;
        public static final int MISSING = 3;
        public static final int OBSTRUCTED = 4;
        public static final int CHANGED = 5;
        public static final int MERGED = 6;
        public static final int CONFLICTED = 7;
        public static final String[] statusNames = new String[]{"inapplicable", "unknown", "unchanged", "missing", "obstructed", "changed", "merged", "conflicted"};
        public static final String[] shortStatusNames = new String[]{" ", " ", " ", "?", "O", "U", "G", "C"};
    }

    public static class PerformedAction {
        public static final int ADD = 0;
        public static final int COPY = 1;
        public static final int DELETE = 2;
        public static final int RESTORE = 3;
        public static final int REVERT = 4;
        public static final int FAILED_REVERT = 5;
        public static final int RESOLVED = 6;
        public static final int SKIP = 7;
        public static final int UPDATE_DELETE = 8;
        public static final int UPDATE_ADD = 9;
        public static final int UPDATE_UPDATE = 10;
        public static final int UPDATE_COMPLETED = 11;
        public static final int UPDATE_EXTERNAL = 12;
        public static final int STATUS_COMPLETED = 13;
        public static final int STATUS_EXTERNAL = 14;
        public static final int COMMIT_MODIFIED = 15;
        public static final int COMMIT_ADDED = 16;
        public static final int COMMIT_DELETED = 17;
        public static final int COMMIT_REPLACED = 18;
        public static final int COMMIT_POSTFIX_TXDELTA = 19;
        public static final int BLAME_REVISION = 20;
        public static final int LOCKED = 21;
        public static final int UNLOCKED = 22;
        public static final int FAILED_LOCK = 23;
        public static final int FAILED_UNLOCK = 24;
        public static final int EXISTS = 25;
        public static final int CHANGELIST_SET = 26;
        public static final int CHANGELIST_CLEAR = 27;
        public static final int MERGE_BEGIN = 28;
        public static final int FOREIGN_MERGE_BEGIN = 29;
        public static final int UPDATE_REPLACED = 30;
        public static final String[] actionNames = new String[]{"add", "copy", "delete", "restore", "revert", "failed revert", "resolved", "skip", "update delete", "update add", "update modified", "update completed", "update external", "status completed", "status external", "sending modified", "sending added", "sending deleted", "sending replaced", "transfer", "blame revision processed", "locked", "unlocked", "locking failed", "unlocking failed", "path exists", "changelist set", "changelist cleared", "merge begin", "foreign merge begin", "replaced"};

        public static boolean isKnownAction(int action) {
            return action >= 0 && action <= 30;
        }
    }
}

