/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SwitchOperation
extends AbstractFileOperation {
    protected IRepositoryResource destination;

    public SwitchOperation(File file, IRepositoryResource destination) {
        super("Operation.SwitchFile", new File[]{file});
        this.destination = destination;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        this.writeToConsole(0, "svn switch \"" + this.destination.getUrl() + "\" \"" + FileUtility.normalizePath(file.getAbsolutePath()) + "\" -r " + this.destination.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
        try {
            proxy.doSwitch(file.getAbsolutePath(), SVNUtility.getEntryRevisionReference(this.destination), ISVNConnector.Depth.infinityOrFiles(true), 0L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

