/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreatePatchOperation
extends AbstractActionOperation {
    public static final int SELECTION = 0;
    public static final int PROJECT = 1;
    public static final int WORKSPACE = 2;
    protected IResource[] resources;
    protected IResource[] selection;
    protected String fileName;
    protected boolean recurse;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean processUnversioned;
    protected int rootPoint;
    protected String lineFeed = System.getProperty("line.separator");
    protected String contentSeparator = String.valueOf(this.lineFeed) + "===================================================================" + this.lineFeed;
    protected String indexEntry = "Index: ";
    protected String removeSign = "--- ";
    protected String addSign = "+++ ";
    protected String revisionMark = "\t(revision 0)" + this.lineFeed;
    protected String noLF = "\\ No newline at end of file" + this.lineFeed;
    protected String rangeStart = "@@ -0,0 +1";
    protected String rangeEnd = " @@" + this.lineFeed;

    public CreatePatchOperation(IResource[] resources, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean processUnversioned) {
        this(resources, fileName, recurse, ignoreDeleted, processBinary, processUnversioned, 1);
    }

    public CreatePatchOperation(IResource[] resources, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean processUnversioned, int rootPoint) {
        super("Operation.CreatePatchLocal");
        this.resources = resources;
        this.fileName = fileName;
        this.recurse = recurse;
        this.ignoreDeleted = ignoreDeleted;
        this.processBinary = processBinary;
        this.processUnversioned = processUnversioned;
        this.rootPoint = rootPoint;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        Map<IProject, List<IResource>> workingCopies = SVNUtility.splitWorkingCopies(this.resources);
        final FileOutputStream stream = new FileOutputStream(this.fileName);
        try {
            if (workingCopies.size() > 1 || this.rootPoint == 2) {
                this.rootPoint = 2;
                stream.write("### Eclipse Workspace Patch 1.0".getBytes());
                stream.write(this.lineFeed.getBytes());
            } else if (this.rootPoint == 0) {
                this.selection = FileUtility.shrinkChildNodes(this.resources);
            }
            Iterator<Map.Entry<IProject, List<IResource>>> it = workingCopies.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry<IProject, List<IResource>> entry = it.next();
                IProject project = entry.getKey();
                if (this.rootPoint == 2) {
                    stream.write("#P ".getBytes());
                    stream.write(project.getName().getBytes());
                    stream.write(this.lineFeed.getBytes());
                }
                IResource[] resources = entry.getValue().toArray(new IResource[0]);
                int i = 0;
                while (i < resources.length && !monitor.isCanceled()) {
                    if (resources[i] instanceof IFile) {
                        this.addFileDiff(stream, (IFile)resources[i], monitor);
                    } else if (this.recurse) {
                        FileUtility.visitNodes(resources[i], new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IFile) {
                                    try {
                                        CreatePatchOperation.this.addFileDiff(stream, (IFile)resource, monitor);
                                    }
                                    catch (RuntimeException ex) {
                                        throw ex;
                                    }
                                    catch (CoreException ex) {
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                return true;
                            }
                        }, 2);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addFileDiff(OutputStream stream, IFile resource, IProgressMonitor monitor) throws Exception {
        ILocalResource local;
        String wcPath = FileUtility.getWorkingCopyPath((IResource)resource);
        String projectPath = FileUtility.getWorkingCopyPath((IResource)resource.getProject());
        String fileName = wcPath.substring(projectPath.length() + 1);
        if (this.rootPoint == 0) {
            IPath resourcePath = resource.getFullPath();
            int i = 0;
            while (i < this.selection.length) {
                IPath selectionPath = this.selection[i].getFullPath();
                if (selectionPath.isPrefixOf(resourcePath)) {
                    fileName = this.selection[i].getType() == 1 ? (fileName = resource.getName()) : resourcePath.toString().substring(selectionPath.toString().length() + 1);
                    break;
                }
                ++i;
            }
        }
        if (IStateFilter.SF_VERSIONED.accept(local = SVNRemoteStorage.instance().asLocalResourceAccessible((IResource)resource))) {
            File tmp = File.createTempFile("patch", ".tmp", SVNTeamPlugin.instance().getStateLocation().toFile());
            tmp.deleteOnExit();
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation((IResource)resource);
            ISVNConnector proxy = location.acquireSVNProxy();
            long options = 512L;
            options |= this.ignoreDeleted ? 8192L : 0L;
            options |= this.processBinary ? 4L : 0L;
            try {
                proxy.diff(new SVNEntryRevisionReference(wcPath, null, SVNRevision.BASE), new SVNEntryRevisionReference(wcPath, null, SVNRevision.WORKING), projectPath, tmp.getAbsolutePath(), 0, options, null, new SVNProgressMonitor(this, monitor, null));
                int len = (int)tmp.length();
                if (len <= 0) return;
                byte[] data = new byte[len];
                FileInputStream input = new FileInputStream(tmp);
                try {
                    ((InputStream)input).read(data);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)input).close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    ((InputStream)input).close();
                }
                catch (Exception exception) {}
                String diff = new String(data);
                int idx = diff.indexOf(this.contentSeparator);
                if (idx != -1) {
                    String diffTail = diff.substring(idx);
                    idx = diffTail.indexOf(this.removeSign);
                    int idx1 = diffTail.indexOf(9, idx);
                    if (idx != -1 && idx1 != -1) {
                        diffTail = String.valueOf(diffTail.substring(0, idx + this.removeSign.length())) + fileName + diffTail.substring(idx1);
                    }
                    idx = diffTail.indexOf(this.addSign);
                    idx1 = diffTail.indexOf(9, idx);
                    if (idx != -1 && idx1 != -1) {
                        diffTail = String.valueOf(diffTail.substring(0, idx + this.addSign.length())) + fileName + diffTail.substring(idx1);
                    }
                    diff = String.valueOf(this.indexEntry) + fileName + diffTail;
                }
                stream.write(diff.getBytes());
                return;
            }
            finally {
                location.releaseSVNProxy(proxy);
                tmp.delete();
            }
        }
        if (!this.processUnversioned || IStateFilter.SF_IGNORED.accept(local)) return;
        int type = FileUtility.getMIMEType((IResource)resource);
        if (!this.processBinary && type == 2) return;
        stream.write(this.getNewFileDiff(wcPath, fileName).getBytes());
    }

    protected String getNewFileDiff(String path, String fileName) throws Exception {
        String string;
        File file = new File(path);
        byte[] data = new byte[(int)file.length()];
        FileInputStream stream = new FileInputStream(file);
        try {
            ((InputStream)stream).read(data);
            string = this.getNewContentDiff(fileName, new String(data));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (Exception exception) {}
        return string;
    }

    protected String getNewContentDiff(String fileName, String content) {
        if (content.length() == 0) {
            return this.getEmptyNewContentDiff(fileName);
        }
        ArrayList<String> tLines = new ArrayList<String>();
        int i = 0;
        int lineStart = 0;
        int m = content.length();
        while (i < m) {
            if (content.charAt(i) == '\n') {
                tLines.add(content.substring(lineStart, ++i));
                lineStart = i;
                continue;
            }
            if (content.charAt(i) == '\r') {
                if (++i < m && content.charAt(i) == '\n') {
                    ++i;
                }
                tLines.add(content.substring(lineStart, i));
                lineStart = i;
                continue;
            }
            if (++i != m) continue;
            tLines.add(content.substring(lineStart, i));
        }
        String[] lines = tLines.toArray(new String[tLines.size()]);
        String retVal = this.getFilledNewContentDiff(fileName, lines);
        if (!(content.endsWith("\r\n") || content.endsWith("\r") || content.endsWith("\n"))) {
            retVal = String.valueOf(retVal) + this.noLF;
        }
        return retVal;
    }

    protected String getFilledNewContentDiff(String fileName, String[] lines) {
        String retVal = String.valueOf(this.getEmptyNewContentDiff(fileName)) + this.removeSign + fileName + this.revisionMark + this.addSign + fileName + this.revisionMark + this.rangeStart + (lines.length == 1 ? "" : "," + lines.length) + this.rangeEnd;
        int i = 0;
        while (i < lines.length) {
            retVal = String.valueOf(retVal) + "+" + lines[i];
            ++i;
        }
        return retVal;
    }

    protected String getEmptyNewContentDiff(String fileName) {
        return String.valueOf(this.indexEntry) + fileName + this.contentSeparator;
    }
}

