/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.utility.FileUtility;

public class DisconnectOperation
extends AbstractActionOperation {
    protected IProject[] projects;
    protected boolean dropSVNFolders;

    public DisconnectOperation(IProject[] projects, boolean dropSVNFolders) {
        super("Operation.Disconnect");
        this.projects = projects;
        this.dropSVNFolders = dropSVNFolders;
    }

    public ISchedulingRule getSchedulingRule() {
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < this.projects.length) {
            rules.add(SVNResourceRuleFactory.INSTANCE.modifyRule((IResource)this.projects[i]));
            ++i;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.projects.length) {
            final IProject current = this.projects[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    RepositoryProvider.unmap((IProject)current);
                    if (DisconnectOperation.this.dropSVNFolders) {
                        FileUtility.removeSVNMetaInformation((IResource)current, null);
                    }
                }
            }, monitor, this.projects.length);
            ++i;
        }
    }
}

