/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.refactor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class CopyResourceWithHistoryOperation
extends AbstractActionOperation {
    protected IResource source;
    protected IResource destination;

    public CopyResourceWithHistoryOperation(IResource source, IResource destination) {
        super("Operation.CopyLocalH");
        this.source = source;
        this.destination = destination;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.destination instanceof IProject ? this.destination : this.destination.getParent();
    }

    public boolean isAllowed() {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation locationSource = storage.getRepositoryLocation(this.source);
        IRepositoryLocation locationDestination = storage.getRepositoryLocation(this.destination);
        ILocalResource localSource = storage.asLocalResource(this.source);
        return IStateFilter.SF_ONREPOSITORY.accept(localSource) && locationSource.equals(locationDestination);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation(this.source);
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn copy \"" + FileUtility.normalizePath(FileUtility.getWorkingCopyPath(this.source)) + "\" \"" + FileUtility.getWorkingCopyPath(this.destination) + "\"\n");
            proxy.copy(new String[]{FileUtility.getWorkingCopyPath(this.source)}, FileUtility.getWorkingCopyPath(this.destination), SVNRevision.WORKING, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.source.getName(), this.destination.toString());
    }
}

