/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ExportOperation
extends AbstractRepositoryOperation {
    protected String path;
    protected int depth;

    public ExportOperation(IRepositoryResource[] resources, String path, int depth) {
        super("Operation.ExportRevision", resources);
        this.path = path;
        this.depth = depth;
    }

    public ExportOperation(IRepositoryResourceProvider provider, String path, int depth) {
        super("Operation.ExportRevision", provider);
        this.path = path;
        this.depth = depth;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            final String path = String.valueOf(this.path) + "/" + resources[i].getName();
            final SVNEntryRevisionReference entryRef = SVNUtility.getEntryRevisionReference(resources[i]);
            this.writeToConsole(0, "svn export \"" + resources[i].getUrl() + "@" + resources[i].getPegRevision() + "\" -r " + resources[i].getSelectedRevision() + " \"" + FileUtility.normalizePath(path) + "\"" + SVNUtility.getDepthArg(this.depth) + " --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.doExport(entryRef, path, null, ExportOperation.this.depth, 4L, new SVNProgressMonitor(ExportOperation.this, monitor, null));
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

