/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractToOperationRemote
extends AbstractRepositoryOperation {
    private Collection<String> toDelete;
    private IRepositoryResourceProvider deletionsProvider;
    private String path;
    private boolean delitionAllowed;
    private HashMap<String, String> exportRoots2Names;

    public ExtractToOperationRemote(IRepositoryResource[] incomingResources, Collection<String> markedForDelition, String path, HashMap<String, String> resource2projectNames, boolean delitionAllowed) {
        super("Operation.ExtractTo", incomingResources);
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.toDelete = markedForDelition;
        this.exportRoots2Names = resource2projectNames;
    }

    public ExtractToOperationRemote(IRepositoryResourceProvider incomingResourcesProvider, Collection<String> markedForDelition, String path, HashMap<String, String> exportRoots2Names, boolean delitionAllowed) {
        super("Operation.ExtractTo", incomingResourcesProvider);
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.toDelete = markedForDelition;
        this.exportRoots2Names = exportRoots2Names;
    }

    public ExtractToOperationRemote(IRepositoryResourceProvider incomingResourcesProvider, IRepositoryResourceProvider markedForDelition, String path, HashMap<String, String> exportRoots2Names, boolean delitionAllowed) {
        super("Operation.ExtractTo", incomingResourcesProvider);
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.deletionsProvider = markedForDelition;
        this.exportRoots2Names = exportRoots2Names;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        if (this.deletionsProvider != null) {
            IRepositoryResource[] deletions = this.deletionsProvider.getRepositoryResources();
            this.toDelete = new HashSet<String>();
            if (deletions != null) {
                IRepositoryResource[] iRepositoryResourceArray = deletions;
                int n = deletions.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepositoryResource deletion = iRepositoryResourceArray[n2];
                    this.toDelete.add(deletion.getUrl());
                    ++n2;
                }
            }
        }
        int processed = 0;
        SVNUtility.reorder(resources, true);
        String previousPref = null;
        String previousPath = null;
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n3 = 0;
        while (n3 < n) {
            IRepositoryResource current = iRepositoryResourceArray[n3];
            String currentURL = current.getUrl();
            Path currentPath = new Path(currentURL);
            String toOperate = "";
            String rootUrl = null;
            String rootName = null;
            for (String url : this.exportRoots2Names.keySet()) {
                if (!new Path(url).isPrefixOf((IPath)currentPath)) continue;
                rootUrl = url;
                rootName = this.exportRoots2Names.get(url);
            }
            if (previousPref == null || !new Path(previousPref).isPrefixOf((IPath)currentPath)) {
                if (current instanceof IRepositoryContainer) {
                    previousPref = current.getUrl();
                }
                previousPath = "/" + (rootUrl == null ? current.getName() : current.getUrl().substring(rootUrl.lastIndexOf(47) + 1));
                toOperate = String.valueOf(this.path) + previousPath;
            } else {
                toOperate = String.valueOf(this.path) + previousPath + currentURL.substring(previousPref.length());
            }
            if (rootUrl != null) {
                String projectRepoName = rootUrl.substring(rootUrl.lastIndexOf("/") + 1);
                String[] parts = toOperate.split(projectRepoName);
                toOperate = String.valueOf(parts[0]) + rootName;
                int i = 1;
                while (i < parts.length) {
                    toOperate = String.valueOf(toOperate) + parts[i];
                    ++i;
                }
            }
            File operatingDirectory = new File(toOperate);
            InitExtractLogOperation.logToAll(this.path, operatingDirectory.getAbsolutePath().substring(this.path.length() + 1));
            if (this.toDelete.contains(current.getUrl())) {
                InitExtractLogOperation.logToDeletions(this.path, operatingDirectory.getAbsolutePath().substring(this.path.length() + 1), true);
                if (operatingDirectory.exists() && this.delitionAllowed) {
                    FileUtility.deleteRecursive(operatingDirectory);
                }
            } else if (current instanceof IRepositoryContainer) {
                monitor.subTask(SVNTeamPlugin.instance().getResource("Operation.ExtractTo.Folders", new String[]{currentURL}));
                operatingDirectory.mkdirs();
            } else {
                monitor.subTask(SVNTeamPlugin.instance().getResource("Operation.ExtractTo.Folders", new String[]{currentURL}));
                if (operatingDirectory.getParentFile() != null) {
                    operatingDirectory.getParentFile().mkdirs();
                }
                monitor.subTask(SVNTeamPlugin.instance().getResource("Operation.ExtractTo.RemoteFile", new String[]{currentURL}));
                this.downloadFile(current, toOperate, monitor);
            }
            ProgressMonitorUtility.progress(monitor, processed++, resources.length);
            ++n3;
        }
    }

    protected void downloadFile(IRepositoryResource remote, String downloadPath, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = remote.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            FileOutputStream stream = new FileOutputStream(downloadPath);
            try {
                proxy.streamFileContent(SVNUtility.getEntryRevisionReference(remote), 2048, stream, new SVNProgressMonitor(this, monitor, null));
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    @Override
    public int getOperationWeight() {
        if (this.operableData() != null && this.operableData().length == 0) {
            return 0;
        }
        return 4;
    }
}

