/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.ICommentProvider;
import org.eclipse.team.svn.core.resource.IFolderChange;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNLocalFolder;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;

public class SVNFolderChange
extends SVNLocalFolder
implements IFolderChange {
    protected SVNRevision pegRevision;
    protected IRepositoryResource originator;
    protected String comment;
    protected ICommentProvider provider;

    public SVNFolderChange(IResource resource, long revision, String status, int changeMask, String author, long lastCommitDate, SVNRevision pegRevision, String comment) {
        super(resource, revision, revision, status, changeMask, author, lastCommitDate);
        this.comment = comment;
        this.pegRevision = pegRevision;
    }

    public void treatAsReplacement() {
        this.status = "Replaced";
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision == null ? (this.revision != -1L ? SVNRevision.fromNumber(this.revision) : SVNRevision.INVALID_REVISION) : this.pegRevision;
    }

    public void setPegRevision(SVNRevision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public ILocalResource[] getChildren() {
        return new ILocalResource[0];
    }

    public IRepositoryResource getOriginator() {
        if (this.originator == null && this.getRevision() != -1L) {
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(this.resource);
            remote.setPegRevision(this.getPegRevision());
            remote.setSelectedRevision(SVNRevision.fromNumber(this.getRevision()));
            return remote;
        }
        return this.originator;
    }

    public void setOriginator(IRepositoryResource originator) {
        this.originator = originator;
    }

    public synchronized String getComment() {
        if (this.comment == null && this.provider != null) {
            long rev = this.getRevision();
            this.comment = this.provider.getComment(this.getResource(), rev == -1L ? SVNRevision.INVALID_REVISION : SVNRevision.fromNumber(rev), this.getPegRevision());
            this.provider = null;
        }
        return this.comment;
    }

    public void setCommentProvider(ICommentProvider provider) {
        this.provider = provider;
    }
}

