/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.FreezeExternalsOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreExternalsOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SwitchOperation;
import org.eclipse.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.OperationErrorDialog;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.panel.common.AbstractBranchTagPanel;
import org.eclipse.team.svn.ui.panel.common.BranchPanel;
import org.eclipse.team.svn.ui.panel.common.TagPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class BranchTagAction
extends AbstractNonRecursiveTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int actionType;

    public BranchTagAction(int actionType) {
        this.actionType = actionType;
    }

    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        IActionOperation op = BranchTagAction.getBranchTagOperation(this.getShell(), this.actionType, resources);
        if (op != null) {
            this.runScheduled(op);
        }
    }

    public static IActionOperation getBranchTagOperation(Shell shell, int actionType, IResource[] resources) {
        AbstractBranchTagPanel panel;
        DefaultDialog dialog;
        boolean isStructureEnabled;
        IRepositoryResource[] remoteResources = new IRepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            remoteResources[i] = SVNRemoteStorage.instance().asRepositoryResource(resources[i]);
            ++i;
        }
        if (!OperationErrorDialog.isAcceptableAtOnce(remoteResources, actionType == 0 ? SVNUIMessages.BranchTagAction_Error_Branch : SVNUIMessages.BranchTagAction_Error_Tag, shell)) {
            return null;
        }
        Set<Object> nodeNames = new HashSet();
        boolean bl = isStructureEnabled = remoteResources[0].getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        if (isStructureEnabled) {
            nodeNames = org.eclipse.team.svn.ui.action.remote.BranchTagAction.getExistingNodeNames((IRepositoryContainer)(actionType == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]) : SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0])));
        }
        if ((dialog = new DefaultDialog(shell, panel = actionType == 0 ? new BranchPanel(SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources) : new TagPanel(SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources))).open() == 0) {
            boolean forceCreate;
            IRepositoryResource destination = panel.getDestination();
            boolean bl2 = forceCreate = isStructureEnabled && resources.length == 1 && resources[0].getType() == 4;
            if (forceCreate) {
                boolean isSingleProjectLayout = remoteResources[0] instanceof IRepositoryRoot && ((IRepositoryRoot)remoteResources[0]).getKind() == 1 || org.eclipse.team.svn.ui.action.remote.BranchTagAction.isSingleProjectLayout(remoteResources[0]);
                forceCreate &= !isSingleProjectLayout;
            }
            PreparedBranchTagOperation mainOp = new PreparedBranchTagOperation(actionType == 0 ? "Branch" : "Tag", resources, remoteResources, destination, panel.getMessage(), forceCreate);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            IResource[] newResources = panel.getSelectedResources();
            if (newResources != null && newResources.length > 0) {
                op.add((IActionOperation)new AddToSVNOperation(newResources, false));
            }
            if (panel.isFreezeExternals()) {
                FreezeExternalsOperation freezeOp = new FreezeExternalsOperation(resources);
                op.add((IActionOperation)freezeOp);
                op.add((IActionOperation)mainOp, new IActionOperation[]{freezeOp});
                op.add((IActionOperation)new RestoreExternalsOperation(freezeOp));
            } else {
                op.add((IActionOperation)mainOp);
            }
            if (newResources != null && newResources.length > 0) {
                op.add((IActionOperation)new RevertOperation(newResources, false));
            }
            if (panel.isStartWithSelected()) {
                SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                op.add((IActionOperation)saveOp);
                SwitchOperation switchOp = new SwitchOperation(resources, (IRepositoryResourceProvider)mainOp, 3);
                op.add((IActionOperation)switchOp, new IActionOperation[]{mainOp});
                op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                op.add((IActionOperation)new RefreshResourcesOperation(resources));
                op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)switchOp));
            }
            return op;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

