/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;

public class RepositoryResourceOnlySelectionComposite
extends Composite {
    protected Label urlLabel;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory urlHistory;
    protected IValidationManager validationManager;
    protected IRepositoryResource baseResource;
    protected String url;
    protected CompositeVerifier verifier;
    protected String selectionTitle;
    protected String selectionDescription;
    protected String comboId;
    protected boolean foldersOnly;
    protected boolean isMatchToBaseResource;

    public RepositoryResourceOnlySelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, IRepositoryResource baseResource, String selectionTitle, String selectionDescription) {
        this(parent, style, validationManager, historyKey, "RepositoryResourceOnlySelectionComposite_URL", baseResource, selectionTitle, selectionDescription);
    }

    public RepositoryResourceOnlySelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, String comboId, IRepositoryResource baseResource, String selectionTitle, String selectionDescription) {
        super(parent, style);
        this.urlHistory = new UserInputHistory(historyKey);
        this.validationManager = validationManager;
        this.baseResource = baseResource;
        this.selectionTitle = selectionTitle;
        this.selectionDescription = selectionDescription;
        this.comboId = comboId;
        this.foldersOnly = !(baseResource instanceof IRepositoryFile);
        this.createControls();
    }

    public void setMatchToBaseResource(boolean isMatchToBaseResource) {
        this.isMatchToBaseResource = isMatchToBaseResource;
    }

    public boolean isMatchToBaseResource() {
        return this.isMatchToBaseResource;
    }

    public void setBaseResource(IRepositoryResource baseResource) {
        this.baseResource = baseResource;
        this.urlText.setText(this.baseResource.getUrl());
    }

    public void setFoldersOnly(boolean foldersOnly) {
        this.foldersOnly = foldersOnly;
    }

    public boolean isSelectionAvailable() {
        return this.getDestination(SVNUtility.asEntryReference((String)this.url), true) != null;
    }

    public IRepositoryResource getSelectedResource() {
        IRepositoryResource resource = this.getDestination(SVNUtility.asEntryReference((String)this.url), false);
        return resource;
    }

    public void addVerifier(AbstractVerifier verifier) {
        this.verifier.add(verifier);
    }

    public void removeVerifier(AbstractVerifier verifier) {
        this.verifier.remove(verifier);
    }

    public void setUrl(String url) {
        this.urlText.setText(url);
    }

    public String getUrl() {
        return this.urlText.getText();
    }

    public void saveHistory() {
        this.urlHistory.addLine(this.urlText.getText());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlLabel.setEnabled(enabled);
        this.urlText.setEnabled(enabled);
        this.browse.setEnabled(enabled);
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.urlLabel = new Label((Composite)this, 0);
        this.urlLabel.setLayoutData((Object)new GridData());
        this.urlLabel.setText(SVNUIMessages.getString(this.comboId));
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        if (this.baseResource != null) {
            this.urlText.setText(this.baseResource.getUrl());
        }
        this.url = this.urlText.getText();
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryResourceOnlySelectionComposite.this.url = ((Combo)e.widget).getText();
            }
        });
        this.verifier = new CompositeVerifier();
        this.verifier.add(new NonEmptyFieldVerifier(SVNUIMessages.getString(String.valueOf(this.comboId) + "_Verifier")));
        this.verifier.add(new URLVerifier(SVNUIMessages.getString(String.valueOf(this.comboId) + "_Verifier")){

            protected String getErrorMessage(Control input) {
                String error = super.getErrorMessage(input);
                if (RepositoryResourceOnlySelectionComposite.this.baseResource != null && error == null) {
                    String baseResourceUrl;
                    String url = this.getText(input);
                    if (RepositoryResourceOnlySelectionComposite.this.getDestination(SVNUtility.asEntryReference((String)url), true) == null) {
                        error = SVNUIMessages.format((String)SVNUIMessages.RepositoryResourceOnlySelectionComposite_URL_Verifier_Error, (Object[])new String[]{url, RepositoryResourceOnlySelectionComposite.this.baseResource.getRepositoryLocation().getUrl()});
                    }
                    if (error == null && RepositoryResourceOnlySelectionComposite.this.isMatchToBaseResource && !url.startsWith(baseResourceUrl = RepositoryResourceOnlySelectionComposite.this.baseResource.getUrl())) {
                        error = SVNUIMessages.format((String)SVNUIMessages.RepositoryResourceOnlySelectionComposite_URL_Verifier_Error, (Object[])new String[]{url, baseResourceUrl});
                    }
                }
                return error;
            }
        });
        this.verifier.add(new AbsolutePathVerifier(this.comboId));
        this.validationManager.attachTo((Control)this.urlText, this.verifier);
        this.browse = new Button(select, 8);
        this.browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.RepositoryResourceOnlySelectionComposite_Select_Title, RepositoryResourceOnlySelectionComposite.this.selectionTitle, RepositoryResourceOnlySelectionComposite.this.selectionDescription, null, true, (IRepositoryBase)RepositoryResourceOnlySelectionComposite.this.baseResource);
                panel.setAllowFiles(!RepositoryResourceOnlySelectionComposite.this.foldersOnly);
                DefaultDialog browser = new DefaultDialog(RepositoryResourceOnlySelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    IRepositoryResource selectedResource = panel.getSelectedResource();
                    boolean samePeg = RepositoryResourceOnlySelectionComposite.this.baseResource != null && selectedResource.getPegRevision().equals((Object)RepositoryResourceOnlySelectionComposite.this.baseResource.getPegRevision());
                    RepositoryResourceOnlySelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : SVNUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    RepositoryResourceOnlySelectionComposite.this.validationManager.validateContent();
                }
            }
        });
    }

    protected IRepositoryResource getDestination(SVNEntryReference ref, boolean allowsNull) {
        if (ref == null) {
            if (this.baseResource == null) {
                if (allowsNull) {
                    return null;
                }
                throw new IllegalArgumentException("SVN entry reference cannot be null.");
            }
            return SVNUtility.copyOf((IRepositoryResource)this.baseResource);
        }
        String url = SVNUtility.normalizeURL((String)ref.path);
        try {
            IRepositoryResource base = this.baseResource;
            IRepositoryResource resource = null;
            if (base != null) {
                resource = this.foldersOnly ? this.baseResource.asRepositoryContainer(url, false) : this.baseResource.asRepositoryFile(url, false);
            } else {
                SVNUtility.getSVNUrl((String)url);
                resource = SVNUtility.asRepositoryResource((String)url, (boolean)this.foldersOnly);
            }
            if (ref.pegRevision != null) {
                resource.setPegRevision(ref.pegRevision);
            }
            return resource;
        }
        catch (Exception exception) {
            if (allowsNull) {
                return null;
            }
            if (this.baseResource == null) {
                throw new IllegalArgumentException("SVN entry reference must contain a valid value.");
            }
            return SVNUtility.copyOf((IRepositoryResource)this.baseResource);
        }
    }
}

