/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class GetRemoteFolderChildrenOperation
extends AbstractActionOperation {
    protected IRepositoryContainer parent;
    protected IRepositoryResource[] children;
    protected boolean sortChildren;
    protected Map<IRepositoryResource, String> externalsNames;

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent) {
        this(parent, true);
    }

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent, boolean sortChildren) {
        super("Operation_GetRemoteChildren");
        this.parent = parent;
        this.sortChildren = sortChildren;
        this.externalsNames = new HashMap<IRepositoryResource, String>();
    }

    public IRepositoryResource[] getChildren() {
        return this.children;
    }

    public String getExternalsName(IRepositoryResource resource) {
        return this.externalsNames.get(resource);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] tmp = this.parent.getChildren();
        IRepositoryResource.Information info = this.parent.getInfo();
        if (info != null && info.hasProperties && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "showExternals")) {
            IRepositoryLocation location = this.parent.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                SVNProperty data = proxy.getProperty(SVNUtility.getEntryRevisionReference((IRepositoryResource)this.parent), "svn:externals", (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                if (data != null) {
                    try {
                        Map externals = SVNUtility.parseSVNExternalsProperty((String)data.value, (IRepositoryResource)this.parent);
                        ArrayList<IRepositoryResource> newTmp = new ArrayList<IRepositoryResource>();
                        IRepositoryResource[] iRepositoryResourceArray = tmp;
                        int n = tmp.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRepositoryResource tmpResource = iRepositoryResourceArray[n2];
                            newTmp.add(tmpResource);
                            ++n2;
                        }
                        Iterator it = externals.entrySet().iterator();
                        while (it.hasNext()) {
                            try {
                                Map.Entry entry = it.next();
                                String name = (String)entry.getKey();
                                SVNEntryRevisionReference ref = (SVNEntryRevisionReference)entry.getValue();
                                IRepositoryResource repositoryResourtce = SVNRemoteStorage.instance().asRepositoryResource(location, ref, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                                if (repositoryResourtce == null) continue;
                                repositoryResourtce.setSelectedRevision(ref.revision);
                                repositoryResourtce.setPegRevision(ref.pegRevision);
                                newTmp.add(repositoryResourtce);
                                this.externalsNames.put(repositoryResourtce, name);
                            }
                            catch (Exception e) {
                                this.reportStatus((IStatus)new Status(2, "org.eclipse.team.svn.core.svnnature", 0, this.getShortErrorMessage(e), (Throwable)e));
                            }
                        }
                        tmp = newTmp.toArray(new IRepositoryResource[0]);
                    }
                    catch (UnreportableException ex) {
                        this.reportStatus((IStatus)new Status(2, "org.eclipse.team.svn.core.svnnature", 0, this.getShortErrorMessage(ex), (Throwable)ex));
                    }
                }
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
        if (this.sortChildren) {
            Arrays.sort(tmp, new Comparator<IRepositoryResource>(){

                @Override
                public int compare(IRepositoryResource first, IRepositoryResource second) {
                    boolean firstContainer = first instanceof IRepositoryContainer;
                    boolean secondContainer = second instanceof IRepositoryContainer;
                    if (firstContainer && secondContainer) {
                        boolean firstRoot = first instanceof IRepositoryRoot;
                        boolean secondRoot = second instanceof IRepositoryRoot;
                        return firstRoot == secondRoot ? (firstRoot ? this.compareRoots(((IRepositoryRoot)first).getKind(), ((IRepositoryRoot)second).getKind()) : first.getUrl().compareTo(second.getUrl())) : (firstRoot ? -1 : 1);
                    }
                    return firstContainer == secondContainer ? first.getUrl().compareTo(second.getUrl()) : (firstContainer ? -1 : 1);
                }

                public int compareRoots(int firstKind, int secondKind) {
                    return firstKind < secondKind ? -1 : 1;
                }
            });
        }
        this.children = tmp;
    }
}

