/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.repository.RepositoriesView;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;

public class RefreshRepositoryLocationsOperation
extends AbstractActionOperation {
    protected IRepositoryLocation[] resources;
    protected boolean deep;

    public RefreshRepositoryLocationsOperation(boolean deep) {
        this(null, deep);
    }

    public RefreshRepositoryLocationsOperation(IRepositoryLocation[] resources, boolean deep) {
        super("Operation_RefreshLocations");
        this.resources = resources;
        this.deep = deep;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.resources == null) {
            RepositoriesView.refreshRepositories(this.deep);
            return;
        }
        int i = 0;
        while (i < this.resources.length) {
            final IRepositoryLocation current = this.resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    RepositoriesView.refresh(current, new RepositoryTreeViewer.IRefreshVisitor(){

                        public void visit(Object data) {
                            if (data instanceof RepositoryLocation && (this).RefreshRepositoryLocationsOperation.this.deep) {
                                ((RepositoryLocation)data).refresh();
                            }
                        }
                    });
                }
            }, monitor, this.resources.length);
            ++i;
        }
    }
}

