/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.BranchTagSelectionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;

public class ReplaceBranchTagPanel
extends AbstractDialogPanel {
    protected IRepositoryResource selectedResource;
    protected int type;
    protected IRepositoryResource[] branchTagResources;
    protected long currentRevision;
    protected String historyKey;
    protected BranchTagSelectionComposite selectionComposite;

    public ReplaceBranchTagPanel(IRepositoryResource baseResource, long currentRevision, int type, IRepositoryResource[] branchTagResources) {
        this.selectedResource = baseResource;
        this.type = type;
        this.branchTagResources = branchTagResources;
        if (type == 0) {
            this.dialogTitle = SVNUIMessages.Replace_Branch_Title;
            this.dialogDescription = SVNUIMessages.Replace_Branch_Description;
            this.defaultMessage = SVNUIMessages.Replace_Branch_Message;
            this.historyKey = "branchReplace";
        } else {
            this.dialogTitle = SVNUIMessages.Replace_Tag_Title;
            this.dialogDescription = SVNUIMessages.Replace_Tag_Description;
            this.defaultMessage = SVNUIMessages.Replace_Tag_Message;
            this.historyKey = "tagReplace";
        }
    }

    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        this.selectionComposite = new BranchTagSelectionComposite(parent, 0, this.selectedResource, this.historyKey, this, this.type, this.branchTagResources);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectionComposite.getSelectedResource();
    }

    protected void saveChangesImpl() {
        this.selectionComposite.saveChanges();
    }

    protected void cancelChangesImpl() {
    }
}

