/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.property.IRevisionPropertiesProvider;
import org.eclipse.team.svn.core.operation.remote.SetRevisionPropertyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.events.RevisonPropertyChangeEvent;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.extension.factory.PredefinedProperty;
import org.eclipse.team.svn.ui.preferences.SVNTeamPropsPreferencePage;
import org.eclipse.team.svn.ui.properties.AbstractPropertyEditPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.PropertyVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevPropertiesEditPanel
extends AbstractPropertyEditPanel {
    protected SVNRevision revision;

    public RevPropertiesEditPanel(SVNProperty[] revProperties, SVNRevision revision) {
        super(revProperties, SVNUIMessages.RevisionPropertyEditPanel_Title, SVNUIMessages.format((String)SVNUIMessages.RevisionPropertyEditPanel_Description, (Object[])new String[]{String.valueOf(revision)}));
        Object current2;
        this.revision = revision;
        ArrayList<SVNTeamPropsPreferencePage.CustomProperty> customPropList = new ArrayList<SVNTeamPropsPreferencePage.CustomProperty>((Collection)Arrays.asList(this.customProps));
        ArrayList<String> givenNames = new ArrayList<String>();
        SVNTeamPropsPreferencePage.CustomProperty[] customPropertyArray = this.customProps;
        int n = this.customProps.length;
        int n2 = 0;
        while (n2 < n) {
            current2 = customPropertyArray[n2];
            givenNames.add(((SVNTeamPropsPreferencePage.CustomProperty)current2).propName);
            ++n2;
        }
        for (Object current2 : this.predefinedProperties) {
            givenNames.add(((PredefinedProperty)current2).name);
        }
        customPropertyArray = revProperties;
        n = revProperties.length;
        int n3 = 0;
        while (n3 < n) {
            current2 = customPropertyArray[n3];
            if (!givenNames.contains(((SVNProperty)current2).name)) {
                customPropList.add(new SVNTeamPropsPreferencePage.CustomProperty(((SVNProperty)current2).name, "", ""));
            }
            ++n3;
        }
        this.customProps = customPropList.toArray(new SVNTeamPropsPreferencePage.CustomProperty[customPropList.size()]);
        this.fillVerifiersMap();
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void fillVerifiersMap() {
        for (PredefinedProperty current : this.predefinedProperties) {
            this.verifiers.put(current.name, new PropertyVerifier("EditPropertiesInputField", current.name.equals("svn:autoversioned") ? null : "", current.name, null));
        }
    }

    @Override
    protected List<PredefinedProperty> getPredefinedProperties() {
        ArrayList<PredefinedProperty> properties = new ArrayList<PredefinedProperty>();
        properties.add(new PredefinedProperty(SVNUIMessages.AbstractPropertyEditPanel_svn_description, "", ""));
        properties.add(new PredefinedProperty("svn:log", this.getDescription("SVN_Log"), ""));
        properties.add(new PredefinedProperty("svn:author", this.getDescription("SVN_Author"), ""));
        properties.add(new PredefinedProperty("svn:date", this.getDescription("SVN_Date"), ""));
        properties.add(new PredefinedProperty("svn:autoversioned", this.getDescription("SVN_Autoversioned"), ""));
        return properties;
    }

    protected String getDescription(String id) {
        return SVNUIMessages.getString("Property_" + id);
    }

    @Override
    protected Map<String, String> getPredefinedPropertiesRegexps() {
        return Collections.emptyMap();
    }

    public static void doSetRevisionProperty(RevPropertiesEditPanel panel, final IRepositoryLocation location, final SVNRevision revision) {
        final SVNProperty[] data = new SVNProperty[]{new SVNProperty(panel.getPropertyName(), panel.getPropertyValue())};
        SetRevisionPropertyOperation setPropOp = null;
        CompositeOperation op = new CompositeOperation("");
        if (panel.isFileSelected()) {
            final File f = new File(panel.getPropertyFile());
            AbstractActionOperation loadOp = new AbstractActionOperation("Operation_SLoadFileContent"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(f);
                        byte[] binary = new byte[(int)f.length()];
                        input.read(binary);
                        data[0] = new SVNProperty(data[0].name, new String(binary));
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
            };
            op.add((IActionOperation)loadOp);
            IRevisionPropertiesProvider provider = new IRevisionPropertiesProvider(){

                public SVNProperty[] getRevisionProperties() {
                    return data;
                }
            };
            setPropOp = new SetRevisionPropertyOperation(location, revision, provider);
        } else {
            setPropOp = new SetRevisionPropertyOperation(location, revision, data[0]);
        }
        op.setOperationName(setPropOp.getOperationName());
        op.add((IActionOperation)setPropOp);
        op.add((IActionOperation)new AbstractActionOperation(setPropOp.getOperationName()){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNRemoteStorage.instance().fireRevisionPropertyChangeEvent(new RevisonPropertyChangeEvent(0, revision, location, data[0]));
            }
        }, new IActionOperation[]{setPropOp});
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }
}

