/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.operation.GetRemoteFolderChildrenOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryBranches;
import org.eclipse.team.svn.ui.repository.model.RepositoryError;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryPending;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryTags;
import org.eclipse.team.svn.ui.repository.model.RepositoryTrunk;
import org.eclipse.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PlatformUI;

public class RepositoryFolder
extends RepositoryResource
implements IParentTreeNode {
    protected GetRemoteFolderChildrenOperation childrenOp;

    public RepositoryFolder(RepositoryResource parent, IRepositoryResource resource) {
        super(parent, resource);
    }

    public void refresh() {
        super.refresh();
        this.childrenOp = null;
    }

    public boolean hasChildren() {
        return true;
    }

    public Object[] getChildren(Object o) {
        IRepositoryContainer container = (IRepositoryContainer)this.resource;
        if (this.childrenOp != null) {
            Object[] objectArray;
            Object[] retVal = RepositoryFolder.wrapChildren(this, this.childrenOp.getChildren(), this.childrenOp);
            if (retVal == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.childrenOp.getExecutionState() != 1 ? new RepositoryPending(this) : new RepositoryError(this.childrenOp.getStatus());
            } else {
                objectArray = retVal;
            }
            return objectArray;
        }
        this.childrenOp = new GetRemoteFolderChildrenOperation(container);
        if (!((IRepositoryContainer)this.resource).isChildrenCached()) {
            CompositeOperation op = new CompositeOperation(this.childrenOp.getId());
            op.add((IActionOperation)this.childrenOp);
            op.add((IActionOperation)this.getRefreshOperation(this.getViewer()));
            UIMonitorUtility.doTaskScheduled((IActionOperation)op, new DefaultOperationWrapperFactory(){

                public IActionOperation getLogged(IActionOperation operation) {
                    return new LoggedOperation(operation);
                }
            });
            return new Object[]{new RepositoryPending(this)};
        }
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)this.childrenOp);
        return RepositoryFolder.wrapChildren(this, this.childrenOp.getChildren(), this.childrenOp);
    }

    public Object[] peekChildren(Object o) {
        Object[] objectArray;
        if (this.childrenOp == null) {
            return this.getChildren(o);
        }
        Object[] retVal = RepositoryFolder.wrapChildren(this, this.childrenOp.getChildren(), this.childrenOp);
        if (retVal == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.childrenOp.getExecutionState() != 1 ? new RepositoryPending(this) : new RepositoryError(this.childrenOp.getStatus());
        } else {
            objectArray = retVal;
        }
        return objectArray;
    }

    public static RepositoryResource[] wrapChildren(RepositoryResource parent, IRepositoryResource[] resources, GetRemoteFolderChildrenOperation childrenOp) {
        if (resources == null) {
            return null;
        }
        RepositoryResource[] wrappers = new RepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            String externalsName;
            wrappers[i] = RepositoryFolder.wrapChild(parent, resources[i]);
            if (childrenOp != null && (externalsName = childrenOp.getExternalsName(resources[i])) != null) {
                wrappers[i].setLabel(externalsName);
                wrappers[i].setExternals(true);
            }
            ++i;
        }
        Arrays.sort(wrappers, new Comparator<RepositoryResource>(){

            @Override
            public int compare(RepositoryResource first, RepositoryResource second) {
                boolean isSecondStructureNode;
                boolean isFirstStructureNode = first instanceof RepositoryTrunk || first instanceof RepositoryBranches || first instanceof RepositoryTags;
                boolean bl = isSecondStructureNode = second instanceof RepositoryTrunk || second instanceof RepositoryBranches || second instanceof RepositoryTags;
                if (isFirstStructureNode && !isSecondStructureNode) {
                    return -1;
                }
                if (isSecondStructureNode && !isFirstStructureNode) {
                    return 1;
                }
                if (isFirstStructureNode && isSecondStructureNode) {
                    return 0;
                }
                if (first instanceof RepositoryFolder && !(second instanceof RepositoryFolder)) {
                    return -1;
                }
                if (second instanceof RepositoryFolder && !(first instanceof RepositoryFolder)) {
                    return 1;
                }
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                if (SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive")) {
                    return first.getLabel().compareToIgnoreCase(second.getLabel());
                }
                return first.getLabel().compareTo(second.getLabel());
            }
        });
        return wrappers;
    }

    public static RepositoryResource wrapChild(RepositoryResource parent, IRepositoryResource resource) {
        if (resource instanceof IRepositoryRoot) {
            IRepositoryRoot tmp = (IRepositoryRoot)resource;
            switch (tmp.getKind()) {
                case 1: {
                    return new RepositoryTrunk(parent, (IRepositoryResource)tmp);
                }
                case 2: {
                    return new RepositoryBranches(parent, (IRepositoryResource)tmp);
                }
                case 3: {
                    return new RepositoryTags(parent, (IRepositoryResource)tmp);
                }
            }
            return new RepositoryRoot(parent, (IRepositoryResource)tmp);
        }
        return resource instanceof IRepositoryFile ? new RepositoryFile(parent, resource) : new RepositoryFolder(parent, resource);
    }

    protected ImageDescriptor getImageDescriptorImpl() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }
}

