/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.FiniExtractLogOperation;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.operation.remote.ExtractToOperationRemote;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.RemoteResourceVariant;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ExtractIncomingToActionHelper
extends AbstractActionHelper {
    public ExtractIncomingToActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)info;
                    ILocalResource local = syncInfo.getLocalResource();
                    return IStateFilter.SF_TREE_CONFLICTING.accept(local) ? IStateFilter.SF_ONREPOSITORY.accept(local) : true;
                }
                return false;
            }
        };
    }

    public IActionOperation getOperation() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.configuration.getSite().getShell());
        fileDialog.setText(SVNUIMessages.ExtractToAction_Select_Title);
        fileDialog.setMessage(SVNUIMessages.ExtractToAction_Select_Description);
        String path = fileDialog.open();
        if (path == null) {
            return null;
        }
        IResource[] incomingChanges = this.getSyncInfoSelector().getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, true));
        HashSet<IProject> incomingWithProjects = new HashSet<IProject>((Collection)Arrays.asList(incomingChanges));
        IResource[] iResourceArray = incomingChanges;
        int n = incomingChanges.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            incomingWithProjects.add(current.getProject());
            ++n2;
        }
        incomingChanges = incomingWithProjects.toArray(new IResource[incomingWithProjects.size()]);
        HashSet deletionsOnly = new HashSet(Arrays.asList(this.getSyncInfoSelector().getSelectedResources(new ISyncStateFilter.StateFilterWrapper(null, IStateFilter.SF_DELETED, false))));
        HashSet<IRepositoryResource> incomingResourcesToOperate = new HashSet<IRepositoryResource>();
        HashSet<String> markedForDelition = new HashSet<String>();
        HashMap<String, String> resource2project = new HashMap<String, String>();
        HashMap<String, String> url2status = new HashMap<String, String>();
        IResource[] iResourceArray2 = incomingChanges;
        int n3 = incomingChanges.length;
        int n4 = 0;
        while (n4 < n3) {
            AbstractSVNSyncInfo[] syncInfos;
            IResource current = iResourceArray2[n4];
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(current);
            IRepositoryResource projectRemote = SVNRemoteStorage.instance().asRepositoryResource((IResource)current.getProject());
            if (current instanceof IProject) {
                resource2project.put(remote.getUrl(), current.getName());
            } else if (!new Path(projectRemote.getUrl()).isPrefixOf((IPath)new Path(remote.getUrl()))) {
                resource2project.put(remote.getUrl(), current.getFullPath().toString().substring(1));
            }
            incomingResourcesToOperate.add(remote);
            AbstractSVNSyncInfo[] abstractSVNSyncInfoArray = syncInfos = this.getSVNSyncInfos();
            int n5 = syncInfos.length;
            int n6 = 0;
            while (n6 < n5) {
                AbstractSVNSyncInfo info = abstractSVNSyncInfoArray[n6];
                if (SyncInfo.getDirection((int)info.getKind()) == 8 || SyncInfo.getDirection((int)info.getKind()) == 12) {
                    IResourceChange change = (IResourceChange)((RemoteResourceVariant)info.getRemote()).getResource();
                    if (remote.getUrl().equals(change.getOriginator().getUrl())) {
                        url2status.put(remote.getUrl(), change.getStatus());
                    }
                }
                ++n6;
            }
            if (deletionsOnly.contains(current)) {
                markedForDelition.add(remote.getUrl());
            }
            ++n4;
        }
        InitExtractLogOperation logger = new InitExtractLogOperation(path);
        ExtractToOperationRemote mainOp = new ExtractToOperationRemote(incomingResourcesToOperate.toArray(new IRepositoryResource[incomingResourcesToOperate.size()]), url2status, markedForDelition, path, resource2project, logger, true);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)logger);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new FiniExtractLogOperation(logger));
        return op;
    }
}

