/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action.logicalmodel;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.ResourceVariant;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeLogicalModelAction;
import org.eclipse.team.svn.ui.synchronize.action.ShowHistoryActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ShowHistoryModelAction
extends AbstractSynchronizeLogicalModelAction {
    protected ShowHistoryActionHelper actionHelper;

    public ShowHistoryModelAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.actionHelper = new ShowHistoryActionHelper((IAction)this, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection) && selection.size() == 1) {
            ILocalResource incoming;
            AbstractSVNSyncInfo syncInfo = this.getSelectedSVNSyncInfo();
            if (syncInfo != null && (incoming = ((ResourceVariant)syncInfo.getRemote()).getResource()) instanceof IResourceChange) {
                return IStateFilter.SF_TREE_CONFLICTING.accept(incoming) ? IStateFilter.SF_TREE_CONFLICTING_REPOSITORY_EXIST.accept(incoming) : "Deleted" != incoming.getStatus();
            }
            IResource selectedResource = this.getSelectedResource();
            if (selectedResource != null) {
                return IStateFilter.SF_ONREPOSITORY.accept(SVNRemoteStorage.instance().asLocalResource(selectedResource));
            }
        }
        return false;
    }

    protected IActionOperation getOperation() {
        return this.actionHelper.getOperation();
    }
}

