/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.merge.action;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.GetRemoteContentsOperation;
import org.eclipse.team.svn.core.operation.local.MarkResolvedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.RemoteResourceVariant;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.operation.ClearMergeStatusesOperation;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 8}){

            public boolean select(SyncInfo info) {
                ILocalResource local = ((AbstractSVNSyncInfo)info).getLocalResource();
                return super.select(info) && (!IStateFilter.SF_TREE_CONFLICTING.accept(local) || IStateFilter.SF_TREE_CONFLICTING_REPOSITORY_EXIST.accept(local));
            }
        };
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        AbstractSVNSyncInfo[] infos = this.getSVNSyncInfos();
        HashMap<String, String> remote2local = new HashMap<String, String>();
        ArrayList<IRepositoryResource> remoteSet = new ArrayList<IRepositoryResource>();
        ArrayList<IResource> localSet = new ArrayList<IResource>();
        int i = 0;
        while (i < infos.length) {
            IResource resource = infos[i].getLocal();
            localSet.add(resource);
            IRepositoryResource remote = ((IResourceChange)((RemoteResourceVariant)infos[i].getRemote()).getResource()).getOriginator();
            remoteSet.add(remote);
            remote2local.put(SVNUtility.encodeURL((String)remote.getUrl()), FileUtility.getWorkingCopyPath((IResource)resource));
            ++i;
        }
        IResource[] resources = localSet.toArray(new IResource[localSet.size()]);
        GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(resources, remoteSet.toArray(new IRepositoryResource[remoteSet.size()]), remote2local);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        IResource[] conflicting = FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)IStateFilter.SF_CONFLICTING, (int)0);
        if (conflicting.length > 0) {
            op.add((IActionOperation)new MarkResolvedOperation(conflicting, 3, 3));
        }
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(conflicting.length > 0 ? FileUtility.getParents((IResource[])resources, (boolean)false) : resources));
        op.add((IActionOperation)new ClearMergeStatusesOperation(resources));
        return op;
    }
}

