/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.checkoutas;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DepthSelectionComposite;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class MultipleCheckoutMethodSelectionPage
extends AbstractVerifiedWizardPage {
    protected static final int FIND_PROJECTS = 0;
    protected static final int CHECKOUT_AS_FOLDER = 1;
    protected static final int CHECKOUT_AS_PROJECTS = 2;
    protected int checkoutType;
    protected DepthSelectionComposite recureDepthSelector;
    protected boolean ignoreExternals;
    protected IRepositoryResource[] selectedResources;

    public MultipleCheckoutMethodSelectionPage(IRepositoryResource[] selectedResources) {
        super(MultipleCheckoutMethodSelectionPage.class.getName(), SVNUIMessages.MultipleCheckoutMethodSelectionPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.selectedResources = selectedResources;
        this.checkoutType = 0;
        this.ignoreExternals = false;
        this.setDescription(SVNUIMessages.MultipleCheckoutMethodSelectionPage_Description);
    }

    public boolean isFindProjectsSelected() {
        return this.checkoutType == 0;
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.checkoutType == 1;
    }

    public int getRecureDepth() {
        return this.recureDepthSelector.getDepth();
    }

    public boolean isIgnoreExternalsSelected() {
        return this.ignoreExternals;
    }

    public Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Button findProjectsButton = new Button(composite, 16);
        data = new GridData(768);
        findProjectsButton.setLayoutData((Object)data);
        findProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleCheckoutMethodSelectionPage.this.checkoutType = 0;
                MultipleCheckoutMethodSelectionPage.this.validateContent();
            }
        });
        findProjectsButton.setText(SVNUIMessages.MultipleCheckoutMethodSelectionPage_Find);
        findProjectsButton.setSelection(true);
        Button checkoutAsFolder = new Button(composite, 16);
        data = new GridData(768);
        checkoutAsFolder.setLayoutData((Object)data);
        checkoutAsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleCheckoutMethodSelectionPage.this.checkoutType = 1;
                MultipleCheckoutMethodSelectionPage.this.validateContent();
            }
        });
        checkoutAsFolder.setText(SVNUIMessages.MultipleCheckoutMethodSelectionPage_Folders);
        Button simpleCheckoutButton = new Button(composite, 16);
        data = new GridData(768);
        simpleCheckoutButton.setLayoutData((Object)data);
        simpleCheckoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleCheckoutMethodSelectionPage.this.checkoutType = 2;
                MultipleCheckoutMethodSelectionPage.this.validateContent();
            }
        });
        simpleCheckoutButton.setText(SVNUIMessages.MultipleCheckoutMethodSelectionPage_Projects);
        data = new GridData(1808);
        Table table = new Table(composite, 68356);
        TableLayout tLayout = new TableLayout();
        table.setLayout((Layout)tLayout);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.getTable().setLayoutData((Object)data);
        int maxLength = FileUtility.getMaxStringLength((String[])SVNUtility.asURLArray((IRepositoryResource[])this.selectedResources, (boolean)false));
        this.initializeDialogUnits((Control)composite);
        int width = this.convertWidthInCharsToPixels(maxLength + 12);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        Object cData = null;
        cData = width > 570 ? new ColumnPixelData(width, true) : new ColumnWeightData(100, true);
        tLayout.addColumnData((ColumnLayoutData)cData);
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IRepositoryResource resource = (IRepositoryResource)element;
                return resource.getUrl();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        tableViewer.setInput((Object)this.selectedResources);
        this.recureDepthSelector = new DepthSelectionComposite(composite, 0);
        data = new GridData(768);
        this.recureDepthSelector.setLayoutData(data);
        Button ingnoreExternalsCheckbox = new Button(composite, 32);
        data = new GridData(768);
        ingnoreExternalsCheckbox.setLayoutData((Object)data);
        ingnoreExternalsCheckbox.setSelection(false);
        ingnoreExternalsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleCheckoutMethodSelectionPage.this.ignoreExternals = ((Button)e.widget).getSelection();
            }
        });
        ingnoreExternalsCheckbox.setText(SVNUIMessages.CheckoutMethodSelectionPage_Externals);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.multiSelectionContext");
        return composite;
    }
}

