/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.ProjectCloseListener;
import org.eclipse.team.svn.core.ResourceChangeListener;
import org.eclipse.team.svn.core.SVNFolderListener;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.crashrecovery.DefaultErrorHandlingFacility;
import org.eclipse.team.svn.core.extension.crashrecovery.IErrorHandlingFacility;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SVNTeamPlugin
extends Plugin {
    public static final String NATURE_ID = "org.eclipse.team.svn.core.svnnature";
    public static final String CORE_SVNCLIENT_NAME = "svnconnector";
    private static volatile SVNTeamPlugin instance = null;
    private ProjectCloseListener pcListener;
    private ResourceChangeListener rcListener;
    private SVNFolderListener svnListener;
    private ServiceTracker tracker;
    private IErrorHandlingFacility errorHandlingFacility;
    private boolean isLocationsDirty;

    public SVNTeamPlugin() {
        instance = this;
        this.pcListener = new ProjectCloseListener();
        this.rcListener = new ResourceChangeListener();
        this.svnListener = new SVNFolderListener();
        this.errorHandlingFacility = new DefaultErrorHandlingFacility();
    }

    public void setLocationsDirty(boolean isLocationsDirty) {
        this.isLocationsDirty = isLocationsDirty;
    }

    public boolean isLocationsDirty() {
        return this.isLocationsDirty;
    }

    public static SVNTeamPlugin instance() {
        return instance;
    }

    public IOptionProvider getOptionProvider() {
        return CoreExtensionsManager.instance().getOptionProvider();
    }

    public IErrorHandlingFacility getErrorHandlingFacility() {
        return this.errorHandlingFacility;
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        CoreExtensionsManager.instance().setOptionProvider(optionProvider == null ? IOptionProvider.DEFAULT : optionProvider);
        SVNRemoteStorage.instance().reconfigureLocations();
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Remove Temporary Files"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamPlugin.instance().getStateLocation().toFile().listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        if (!name.equals(".svnRepositories") && !name.equals(".externalSVNRepositories")) {
                            FileUtility.deleteRecursive(pathname);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public IEclipsePreferences getSVNCorePreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.tracker.open();
        IPath stateLocation = this.getStateLocation();
        SVNFileStorage.instance().initialize(stateLocation);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        storage.initialize(stateLocation);
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.rcListener, 1);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.svnListener, 8);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.pcListener, 6);
                try {
                    SVNTeamPlugin.this.rcListener.handleInitialWorkspaceDelta();
                }
                catch (Throwable ex) {
                    LoggedOperation.reportError("Handle Initial Workspace Delta", ex);
                }
                IProject[] projects = workspace.getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    RepositoryProvider.getProvider((IProject)projects[i]);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setUser(false);
        job.schedule();
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.svnListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.rcListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        if (this.isLocationsDirty) {
            SVNRemoteStorage.instance().saveConfiguration();
            SVNFileStorage.instance().saveConfiguration();
        }
        SVNRemoteStorage.instance().dispose();
        SVNFileStorage.instance().dispose();
        this.tracker.close();
        File temporaryFilesStorage = SVNTeamPlugin.instance().getStateLocation().toFile();
        File[] files = temporaryFilesStorage.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().indexOf(".tmp") != -1;
            }
        });
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                FileUtility.deleteRecursive(files[i]);
                ++i;
            }
        }
        super.stop(context);
    }
}

