/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import org.eclipse.team.svn.core.connector.SVNRevision;

public class SVNRevisionRange {
    public final SVNRevision from;
    public final SVNRevision to;

    public SVNRevisionRange(long from, long to) {
        this.from = SVNRevision.fromNumber(from);
        this.to = SVNRevision.fromNumber(to);
    }

    public SVNRevisionRange(SVNRevision from, SVNRevision to) {
        if (from == null) {
            throw new NullPointerException("The \"from\" field cannot be initialized with null");
        }
        if (to == null) {
            throw new NullPointerException("The \"to\" field cannot be initialized with null");
        }
        this.from = from;
        this.to = to;
    }

    public SVNRevisionRange(String revisionElement) {
        int hyphen = revisionElement.indexOf(45);
        if (hyphen > 0) {
            this.from = SVNRevision.fromNumber(Long.parseLong(revisionElement.substring(0, hyphen)));
            this.to = SVNRevision.fromNumber(Long.parseLong(revisionElement.substring(hyphen + 1)));
        } else {
            this.to = this.from = SVNRevision.fromNumber(Long.parseLong(revisionElement.trim()));
        }
    }

    public String toString() {
        if (this.from.equals(this.to)) {
            return this.from.toString();
        }
        return String.valueOf(this.from.toString()) + '-' + this.to.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        return result;
    }

    public boolean equals(Object range) {
        if (this == range) {
            return true;
        }
        if (!(range instanceof SVNRevisionRange)) {
            return false;
        }
        SVNRevisionRange other = (SVNRevisionRange)range;
        return this.from.equals(other.from) && this.to.equals(other.to);
    }
}

