/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LockOperation
extends AbstractFileOperation {
    protected String message;
    protected boolean force;

    public LockOperation(File[] files, String message, boolean force) {
        super("Operation_LockFile", files);
        this.message = message;
        this.force = force;
    }

    public LockOperation(IFileProvider provider, String message, boolean force) {
        super("Operation_LockFile", provider);
        this.message = message;
        this.force = force;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        final ArrayList problems = new ArrayList();
        Map wc2Resources = SVNUtility.splitWorkingCopies(files);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            IRepositoryResource wcRoot = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false);
            final IRepositoryLocation location = wcRoot.getRepositoryLocation();
            final String[] paths = FileUtility.asPathArray(((List)entry.getValue()).toArray(new File[0]));
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    LockOperation.this.writeToConsole(0, "svn lock");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        LockOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    LockOperation.this.writeToConsole(0, String.valueOf(LockOperation.this.force ? " --force" : "") + " -m \"" + LockOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ISVNNotificationCallback listener = new ISVNNotificationCallback(){
                        protected static final int FAILED = 23;

                        public void notify(SVNNotification info) {
                            if (23 == info.action) {
                                problems.add(info);
                            }
                        }
                    };
                    SVNUtility.addSVNNotifyListener(proxy, listener);
                    try {
                        proxy.lock(paths, LockOperation.this.message, LockOperation.this.force ? 4L : 0L, new SVNProgressMonitor(LockOperation.this, monitor, null));
                    }
                    finally {
                        SVNUtility.removeSVNNotifyListener(proxy, listener);
                    }
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
        if (!problems.isEmpty()) {
            StringBuffer res = new StringBuffer();
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                SVNNotification problem = (SVNNotification)iter.next();
                res.append(problem.errMsg);
                if (!iter.hasNext()) continue;
                res.append("\n\n");
            }
            throw new UnreportableException(res.toString());
        }
    }
}

