/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class ExtractToOperationLocal
extends AbstractActionOperation {
    private IResource[] outgoingResources;
    private String path;
    private boolean delitionAllowed;
    private InitExtractLogOperation logger;

    public ExtractToOperationLocal(IResource[] outgoingResources, String path, boolean delitionAllowed, InitExtractLogOperation logger) {
        super(SVNMessages.Operation_ExtractTo);
        this.outgoingResources = outgoingResources;
        this.path = path;
        this.delitionAllowed = delitionAllowed;
        this.logger = logger;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        FileUtility.reorder(this.outgoingResources, true);
        int processed = 0;
        IPath previousPref = null;
        IResource[] iResourceArray = this.outgoingResources;
        int n = this.outgoingResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            IPath currentPath = current.getFullPath();
            String toOperate = "";
            if (previousPref == null || !previousPref.isPrefixOf(currentPath)) {
                toOperate = String.valueOf(this.path) + "/" + current.getName();
                if (current instanceof IContainer) {
                    previousPref = current.getFullPath();
                }
            } else {
                int toRemove = previousPref.removeLastSegments(1).toString().length();
                if (toRemove < 2) {
                    toRemove = 0;
                }
                toOperate = String.valueOf(this.path) + currentPath.toString().substring(toRemove);
            }
            File operatingDirectory = new File(toOperate);
            ILocalResource localResource = SVNRemoteStorage.instance().asLocalResourceAccessible(current);
            if (!IStateFilter.SF_NOTMODIFIED.accept(localResource)) {
                this.logger.log(operatingDirectory.getAbsolutePath().substring(this.path.length() + 1), localResource.getStatus());
            }
            if (IStateFilter.SF_DELETED.accept(localResource)) {
                if (operatingDirectory.exists() && this.delitionAllowed) {
                    FileUtility.deleteRecursive(operatingDirectory);
                }
            } else if (current instanceof IContainer) {
                monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_Folders, new String[]{FileUtility.getWorkingCopyPath(current)}));
                operatingDirectory.mkdirs();
            } else {
                File parent;
                if (previousPref != null && (parent = operatingDirectory.getParentFile()) != null) {
                    monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_Folders, new String[]{FileUtility.getWorkingCopyPath(current)}));
                    parent.mkdirs();
                    operatingDirectory = parent;
                }
                monitor.subTask(SVNMessages.format(SVNMessages.Operation_ExtractTo_LocalFile, new String[]{FileUtility.getWorkingCopyPath(current)}));
                FileUtility.copyAll(operatingDirectory, new File(FileUtility.getWorkingCopyPath(current)), 2, null, monitor);
            }
            ProgressMonitorUtility.progress(monitor, processed++, this.outgoingResources.length);
            ++n2;
        }
    }

    public int getOperationWeight() {
        if (this.outgoingResources.length == 0) {
            return 0;
        }
        return 1;
    }
}

