/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.operation.local.change.visitors.CompositeVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.SavePropertiesVisitor;
import org.eclipse.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreezeExternalsOperation
extends AbstractWorkingCopyOperation
implements IActionOperationProcessor,
IResourceProvider {
    protected ArrayList<ResourceChange> changes = new ArrayList();

    public FreezeExternalsOperation(IResource[] resources) {
        super("Operation_FreezeExternals", resources);
    }

    public FreezeExternalsOperation(IResourceProvider provider) {
        super("Operation_FreezeExternals", provider);
    }

    @Override
    public IResource[] getResources() {
        return this.operableData();
    }

    public Collection<ResourceChange> getChanges() {
        return this.changes;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        final CompositeVisitor visitor = new CompositeVisitor();
        visitor.add(new SavePropertiesVisitor(true));
        visitor.add(new FreezeVisitor());
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ResourceChange change = ResourceChange.wrapLocalResource(null, SVNRemoteStorage.instance().asLocalResourceAccessible(current), false);
                    if (change != null) {
                        change.traverse(visitor, 2, FreezeExternalsOperation.this, monitor);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    @Override
    public void doOperation(IActionOperation op, IProgressMonitor monitor) {
        this.reportStatus(op.run(monitor).getStatus());
    }

    protected class FreezeVisitor
    implements IResourceChangeVisitor {
        protected FreezeVisitor() {
        }

        public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        }

        public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
            SVNProperty[] properties;
            if (change.getLocal() instanceof ILocalFolder && (properties = change.getProperties()) != null) {
                int i = 0;
                while (i < properties.length && !monitor.isCanceled()) {
                    if (properties[i].name.equals("svn:externals")) {
                        FreezeExternalsOperation.this.changes.add(change);
                        this.processExternals(change, properties[i], processor, monitor);
                    }
                    ++i;
                }
            }
        }

        protected void processExternals(ResourceChange change, SVNProperty property, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
            SVNUtility.SVNExternalPropertyData[] externals;
            String newValue = "";
            SVNUtility.SVNExternalPropertyData[] sVNExternalPropertyDataArray = externals = SVNUtility.SVNExternalPropertyData.parse(property.value);
            int n = externals.length;
            int n2 = 0;
            while (n2 < n) {
                SVNUtility.SVNExternalPropertyData external = sVNExternalPropertyDataArray[n2];
                if (external.pegRevision == null && external.revision == null) {
                    IContainer container = (IContainer)change.getLocal().getResource();
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(container.findMember(external.localPath));
                    external.revision = String.valueOf(local.getBaseRevision());
                }
                newValue = String.valueOf(newValue) + external.toString();
                newValue = String.valueOf(newValue) + "\n";
                ++n2;
            }
            SetPropertiesOperation setOp = new SetPropertiesOperation(new IResource[]{change.getLocal().getResource()}, property.name, newValue.getBytes(), false);
            processor.doOperation(setOp, monitor);
        }
    }
}

