/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractMergeSet;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.operation.local.MergeSet1URL;
import org.eclipse.team.svn.core.operation.local.MergeSet2URL;
import org.eclipse.team.svn.core.operation.local.MergeSetReintegrate;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class MergeStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation {
    protected AbstractMergeSet info;
    protected SVNMergeStatus[] retVal;

    public MergeStatusOperation(AbstractMergeSet info, IResource[] resources) {
        super("Operation_MergeStatus", resources == null ? info.to : resources);
        this.info = info;
    }

    public IResource[] getScope() {
        return this.info.to;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ArrayList st = new ArrayList();
        HashSet resources = new HashSet(Arrays.asList(this.operableData()));
        final ISVNMergeStatusCallback cb = new ISVNMergeStatusCallback(){

            public void next(SVNMergeStatus status) {
                st.add(status);
            }
        };
        int i = 0;
        while (i < this.info.to.length && !monitor.isCanceled()) {
            if (resources.contains(this.info.to[i])) {
                ProgressMonitorUtility.setTaskInfo(monitor, this, this.info.to[i].getFullPath().toString());
                final int idx = i;
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        if (MergeStatusOperation.this.info instanceof MergeSet1URL) {
                            MergeStatusOperation.this.doMerge1URL(idx, cb, monitor);
                        } else if (MergeStatusOperation.this.info instanceof MergeSet2URL) {
                            MergeStatusOperation.this.doMerge2URL(idx, cb, monitor);
                        } else {
                            MergeStatusOperation.this.doMergeReintegrate(idx, cb, monitor);
                        }
                    }
                }, monitor, this.info.to.length);
            }
            ++i;
        }
        this.retVal = st.toArray(new SVNMergeStatus[st.size()]);
        this.info.addStatuses(this.retVal);
    }

    public SVNEntryStatus[] getStatuses() {
        return this.retVal;
    }

    public void setPegRevision(IResourceChange change) {
    }

    protected void doMerge1URL(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSet1URL info = (MergeSet1URL)this.info;
        SVNEntryRevisionReference mergeRef = SVNUtility.getEntryRevisionReference(info.from[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        long options = info.ignoreAncestry ? 512L : 0L;
        ISVNConnector proxy = info.from[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            proxy.mergeStatus((SVNEntryReference)mergeRef, info.revisions, wcPath, info.depth, options, cb, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.from[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    protected void doMerge2URL(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSet2URL info = (MergeSet2URL)this.info;
        SVNEntryRevisionReference startRef = SVNUtility.getEntryRevisionReference(info.fromStart[idx]);
        SVNEntryRevisionReference endRef = SVNUtility.getEntryRevisionReference(info.fromEnd[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        long options = info.ignoreAncestry ? 516L : 4L;
        ISVNConnector proxy = info.fromEnd[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            proxy.mergeStatus(startRef, endRef, wcPath, info.depth, options, cb, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.fromEnd[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    protected void doMergeReintegrate(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSetReintegrate info = (MergeSetReintegrate)this.info;
        SVNEntryRevisionReference mergeRef = SVNUtility.getEntryRevisionReference(info.from[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        ISVNConnector proxy = info.from[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            proxy.mergeStatus(mergeRef, wcPath, 0L, cb, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.from[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }
}

