/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RelocateWorkingCopyOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected IRepositoryLocation location;
    protected List<IProject> resources;

    public RelocateWorkingCopyOperation(IResource[] resources, IRepositoryLocation location) {
        super("Operation_RelocateResources", resources);
        this.location = location;
    }

    public RelocateWorkingCopyOperation(IResourceProvider provider, IRepositoryLocation location) {
        super("Operation_RelocateResources", provider);
        this.location = location;
    }

    public IResource[] getResources() {
        return this.resources == null ? new IResource[]{} : this.resources.toArray(new IResource[this.resources.size()]);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.resources = new ArrayList<IProject>();
        IResource[] projects = this.operableData();
        if (projects.length == 0) {
            return;
        }
        final ISVNConnector proxy = this.location.acquireSVNProxy();
        try {
            block7: {
                int i;
                String rootUrl;
                IRepositoryResource[] children;
                block6: {
                    children = this.location.getRepositoryRoot().getChildren();
                    rootUrl = this.location.getRepositoryRootUrl();
                    i = 0;
                    if (!true) break block6;
                    if (i >= projects.length) return;
                    if (monitor.isCanceled()) break block7;
                }
                do {
                    final IProject current = (IProject)projects[i];
                    this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)current, (String)"org.eclipse.team.svn.core.svnnature");
                            IPath fsLocation = current.getLocation();
                            if (fsLocation != null) {
                                String url;
                                String oldRoot;
                                String path = fsLocation.toString();
                                SVNChangeStatus st = SVNUtility.getSVNInfoForNotConnected((IResource)current);
                                if (st != null && (oldRoot = SVNUtility.getOldRoot(url = SVNUtility.decodeURL(st.url), children)) != null) {
                                    RelocateWorkingCopyOperation.this.writeToConsole(0, "svn switch --relocate \"" + oldRoot + "\" \"" + rootUrl + "\" \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(RelocateWorkingCopyOperation.this.location.getUsername()) + "\n");
                                    proxy.relocate(oldRoot, rootUrl, path, 3, new SVNProgressMonitor(RelocateWorkingCopyOperation.this, monitor, null));
                                    provider.switchResource(RelocateWorkingCopyOperation.this.location.asRepositoryContainer(String.valueOf(rootUrl) + url.substring(oldRoot.length()), false));
                                    RelocateWorkingCopyOperation.this.resources.add(current);
                                }
                            }
                        }
                    }, monitor, projects.length);
                    ++i;
                    if (i >= projects.length) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.location.getUrl()});
    }
}

