/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.ISVNStorage;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.svnstorage.SVNCachedProxyCredentialsManager;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.events.IRepositoriesStateChangedListener;
import org.eclipse.team.svn.core.svnstorage.events.IRevisionPropertyChangeListener;
import org.eclipse.team.svn.core.svnstorage.events.RepositoriesStateChangedEvent;
import org.eclipse.team.svn.core.svnstorage.events.RevisonPropertyChangeEvent;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractSVNStorage
implements ISVNStorage {
    private static final String URL_TO_STORE = "http://eclipse.org/subversive/";
    protected File stateInfoFile;
    protected String preferencesNode;
    protected IEclipsePreferences.IPreferenceChangeListener repoPrefChangeListener;
    protected SVNCachedProxyCredentialsManager proxyCredentialsManager;
    protected IRepositoryLocation[] repositories = new IRepositoryLocation[0];
    protected List<IRepositoriesStateChangedListener> repositoriesStateChangedListeners = new ArrayList<IRepositoriesStateChangedListener>();
    protected ArrayList<IRevisionPropertyChangeListener> revPropChangeListeners = new ArrayList();

    public void dispose() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].dispose();
                ++i;
            }
        }
    }

    public void reconfigureLocations() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].reconfigure();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoriesStateChangedListener(IRepositoriesStateChangedListener listener) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            this.repositoriesStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoriesStateChangedListener(IRepositoriesStateChangedListener listener) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            this.repositoriesStateChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepositoriesStateChanged(RepositoriesStateChangedEvent event) {
        List<IRepositoriesStateChangedListener> list = this.repositoriesStateChangedListeners;
        synchronized (list) {
            for (IRepositoriesStateChangedListener listener : this.repositoriesStateChangedListeners) {
                listener.repositoriesStateChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRevisionPropertyChangeListener(IRevisionPropertyChangeListener listener) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            this.revPropChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRevisionPropertyChangeEvent(RevisonPropertyChangeEvent event) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            for (IRevisionPropertyChangeListener current : this.revPropChangeListeners) {
                current.revisionPropertyChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionPropertyChangeListener(IRevisionPropertyChangeListener listener) {
        ArrayList<IRevisionPropertyChangeListener> arrayList = this.revPropChangeListeners;
        synchronized (arrayList) {
            this.revPropChangeListeners.remove(listener);
        }
    }

    public static IEclipsePreferences getRepositoriesPreferences(String prefNode) {
        return (IEclipsePreferences)SVNTeamPlugin.instance().getSVNCorePreferences().node(prefNode);
    }

    public IRepositoryLocation[] getRepositoryLocations() {
        return this.repositories;
    }

    public IRepositoryLocation getRepositoryLocation(String id) {
        int i = 0;
        while (i < this.repositories.length) {
            if (this.repositories[i].getId().equals(id)) {
                return this.repositories[i];
            }
            ++i;
        }
        return null;
    }

    public IRepositoryLocation newRepositoryLocation() {
        return new SVNRepositoryLocation(new UniversalUniqueIdentifier().toString());
    }

    public void copyRepositoryLocation(IRepositoryLocation to, IRepositoryLocation from) {
        to.setStructureEnabled(from.isStructureEnabled());
        to.setBranchesLocation(from.getUserInputBranches());
        to.setTagsLocation(from.getUserInputTags());
        to.setTrunkLocation(from.getUserInputTrunk());
        to.setUrl(from.getUrlAsIs());
        to.setLabel(from.getLabel());
        to.setUsername(from.getUsername());
        to.setPassword(from.getPassword());
        to.setPasswordSaved(from.isPasswordSaved());
        SSHSettings sshOriginal = from.getSSHSettings();
        SSHSettings sshNew = to.getSSHSettings();
        sshNew.setPassPhrase(sshOriginal.getPassPhrase());
        sshNew.setPassPhraseSaved(sshOriginal.isPassPhraseSaved());
        sshNew.setPort(sshOriginal.getPort());
        sshNew.setPrivateKeyPath(sshOriginal.getPrivateKeyPath());
        sshNew.setUseKeyFile(sshOriginal.isUseKeyFile());
        SSLSettings sslOriginal = from.getSSLSettings();
        SSLSettings sslNew = to.getSSLSettings();
        sslNew.setAuthenticationEnabled(sslOriginal.isAuthenticationEnabled());
        sslNew.setCertificatePath(sslOriginal.getCertificatePath());
        sslNew.setPassPhrase(sslOriginal.getPassPhrase());
        sslNew.setPassPhraseSaved(sslOriginal.isPassPhraseSaved());
        if (from instanceof SVNRepositoryLocation && to instanceof SVNRepositoryLocation) {
            SVNRepositoryLocation tmpFrom = (SVNRepositoryLocation)from;
            SVNRepositoryLocation tmpTo = (SVNRepositoryLocation)to;
            tmpTo.repositoryRootUrl = tmpFrom.repositoryRootUrl;
            tmpTo.repositoryUUID = tmpFrom.repositoryUUID;
            tmpTo.getAdditionalRealms().clear();
            for (String realm : from.getRealms()) {
                IRepositoryLocation target = this.newRepositoryLocation();
                IRepositoryLocation source = from.getLocationForRealm(realm);
                this.copyRepositoryLocation(target, source);
                to.addRealm(realm, target);
            }
        }
    }

    public IRepositoryLocation newRepositoryLocation(String reference) {
        if (reference == null) {
            return this.newRepositoryLocation();
        }
        String[] parts = reference.split(";");
        if (parts.length == 0 || parts[0].length() == 0) {
            return this.newRepositoryLocation();
        }
        IRepositoryLocation location = this.getRepositoryLocation(parts[0]);
        if (location != null) {
            return location;
        }
        String id = parts[0].trim();
        location = new SVNRepositoryLocation(id.length() > 0 ? id : new UniversalUniqueIdentifier().toString());
        location.setTrunkLocation("");
        location.setTagsLocation("");
        location.setBranchesLocation("");
        location.setAuthorName("");
        location.fillLocationFromReference(parts);
        return location;
    }

    public String repositoryLocationAsReference(IRepositoryLocation location) {
        return location.asReference();
    }

    public synchronized void addRepositoryLocation(IRepositoryLocation location) {
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>((Collection)Arrays.asList(this.repositories));
        if (!tmp.contains(location)) {
            tmp.add(location);
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
        this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 0));
    }

    public synchronized void removeRepositoryLocation(IRepositoryLocation location) {
        String[] realms;
        ArrayList tmp = new ArrayList(Arrays.asList(this.repositories));
        this.removeAuthInfoForLocation(location, "");
        String[] stringArray = realms = location.getRealms().toArray(new String[0]);
        int n = realms.length;
        int n2 = 0;
        while (n2 < n) {
            String realm = stringArray[n2];
            this.removeAuthInfoForLocation(location, realm);
            ++n2;
        }
        if (tmp.remove(location)) {
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
        this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 1));
    }

    public SVNCachedProxyCredentialsManager getProxyCredentialsManager() {
        return this.proxyCredentialsManager;
    }

    public synchronized void saveConfiguration() throws Exception {
        this.saveLocations();
    }

    public byte[] repositoryResourceAsBytes(IRepositoryResource resource) {
        if (resource == null) {
            return null;
        }
        int selectedKind = resource.getSelectedRevision().getKind();
        int pegKind = resource.getPegRevision().getKind();
        String retVal = String.valueOf(new String(Base64.encode((byte[])String.valueOf(resource instanceof IRepositoryContainer).getBytes()))) + ";" + resource.getRepositoryLocation().getId() + ";" + new String(Base64.encode((byte[])resource.getUrl().getBytes())) + ";" + String.valueOf(selectedKind) + ";" + (selectedKind == 1 ? String.valueOf(((SVNRevision.Number)resource.getSelectedRevision()).getNumber()) : "0") + ";" + String.valueOf(4) + ";" + String.valueOf(pegKind) + ";" + (pegKind == 1 ? String.valueOf(((SVNRevision.Number)resource.getPegRevision()).getNumber()) : "0");
        return retVal.getBytes();
    }

    public IRepositoryResource repositoryResourceFromBytes(byte[] bytes) {
        return this.repositoryResourceFromBytes(bytes, null);
    }

    public IRepositoryResource repositoryResourceFromBytes(byte[] bytes, IRepositoryLocation location) {
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = false;
        boolean base64Label = false;
        if ("true".equals(data[0])) {
            isFolder = true;
        } else if (!"false".equals(data[0])) {
            isFolder = "true".equals(new String(Base64.decode((byte[])data[0].getBytes())));
            base64Label = true;
        }
        if (location == null) {
            location = this.getRepositoryLocation(data[1]);
        }
        if (location == null) {
            return null;
        }
        int revisionKind = Integer.parseInt(data[3]);
        long revNum = Long.parseLong(data[4]);
        SVNRevision selectedRevision = revisionKind == 1 ? (revNum == -1L ? SVNRevision.INVALID_REVISION : SVNRevision.fromNumber(revNum)) : SVNRevision.fromKind(revisionKind);
        SVNRevision pegRevision = null;
        if (data.length > 6) {
            int pegKind = Integer.parseInt(data[6]);
            long pegNum = Long.parseLong(data[7]);
            pegRevision = pegKind == 1 ? (pegNum == -1L ? null : SVNRevision.fromNumber(pegNum)) : SVNRevision.fromKind(pegKind);
        }
        String urlPart = base64Label ? new String(Base64.decode((byte[])data[2].getBytes())) : data[2];
        try {
            SVNUtility.getSVNUrl(urlPart);
        }
        catch (MalformedURLException malformedURLException) {
            String prefix = AbstractSVNStorage.getRootPrefix(location, Integer.parseInt(data[5]));
            urlPart = String.valueOf(prefix) + urlPart;
        }
        location = this.wrapLocationIfRequired(location, urlPart, !isFolder);
        IRepositoryResource retVal = isFolder ? location.asRepositoryContainer(urlPart, false) : location.asRepositoryFile(urlPart, false);
        retVal.setSelectedRevision(selectedRevision);
        retVal.setPegRevision(pegRevision);
        return retVal;
    }

    protected abstract IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation var1, String var2, boolean var3);

    protected static String getRootPrefix(IRepositoryLocation location, int rootKind) {
        switch (rootKind) {
            case 4: {
                return location.getRepositoryRootUrl();
            }
            case 0: {
                return location.getUrl();
            }
            case 1: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTrunkLocation() : location.getUrl();
            }
            case 2: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getBranchesLocation() : location.getUrl();
            }
            case 3: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTagsLocation() : location.getUrl();
            }
        }
        return null;
    }

    protected void initializeImpl(String preferencesNode) throws Exception {
        IProxyService proxyService = SVNTeamPlugin.instance().getProxyService();
        this.proxyCredentialsManager = new SVNCachedProxyCredentialsManager(proxyService);
        proxyService.addProxyChangeListener(new IProxyChangeListener(){

            public void proxyInfoChanged(IProxyChangeEvent event) {
                IProxyData[] newDatas;
                IProxyData[] iProxyDataArray = newDatas = event.getChangedProxyData();
                int n = newDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData current = iProxyDataArray[n2];
                    if (current.isRequiresAuthentication()) {
                        AbstractSVNStorage.this.proxyCredentialsManager.setPassword(current.getPassword());
                        AbstractSVNStorage.this.proxyCredentialsManager.setUsername(current.getUserId());
                        break;
                    }
                    ++n2;
                }
                AbstractSVNStorage.this.dispose();
            }
        });
        this.preferencesNode = preferencesNode;
        this.repoPrefChangeListener = new RepositoryPreferenceChangeListener();
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.preferencesNode);
        repositoryPreferences.addPreferenceChangeListener(this.repoPrefChangeListener);
        if (this.stateInfoFile.exists()) {
            this.loadLocationsFromFile();
            this.stateInfoFile.delete();
            this.saveLocations();
            return;
        }
        try {
            this.loadLocations();
        }
        catch (Exception ex) {
            LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadLocations"), ex);
        }
    }

    protected void saveLocations() throws Exception {
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.preferencesNode);
        repositoryPreferences.removePreferenceChangeListener(this.repoPrefChangeListener);
        repositoryPreferences.clear();
        IRepositoryLocation[] iRepositoryLocationArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            String[] realms;
            IRepositoryLocation current = iRepositoryLocationArray[n2];
            repositoryPreferences.put(current.getId(), this.repositoryLocationAsReference(current));
            this.saveAuthInfo(current, "");
            String[] stringArray = realms = current.getRealms().toArray(new String[0]);
            int n3 = realms.length;
            int n4 = 0;
            while (n4 < n3) {
                String realm = stringArray[n4];
                if (current.isPasswordSavedForRealm(realm)) {
                    this.saveAuthInfo(current, realm);
                }
                ++n4;
            }
            ++n2;
        }
        repositoryPreferences.flush();
        SVNTeamPlugin.instance().savePluginPreferences();
        repositoryPreferences.addPreferenceChangeListener(this.repoPrefChangeListener);
    }

    protected void saveAuthInfo(IRepositoryLocation location, String realm) throws Exception {
        Platform.flushAuthorizationInfo((URL)new URL(URL_TO_STORE), (String)location.getId(), (String)realm);
        IRepositoryLocation tmp = realm.equals("") ? location : location.getLocationForRealm(realm);
        boolean toStorePass = tmp.isPasswordSaved();
        HashMap<String, String> authInfo = new HashMap<String, String>();
        authInfo.put("username", tmp.getUsername());
        authInfo.put("password", toStorePass ? tmp.getPassword() : "");
        authInfo.put("password_saved", String.valueOf(toStorePass));
        SSHSettings sshSettings = tmp.getSSHSettings();
        boolean useKeyFile = sshSettings.isUseKeyFile();
        authInfo.put("ssh_use_key", String.valueOf(useKeyFile));
        boolean savePassphrase = sshSettings.isPassPhraseSaved();
        authInfo.put("ssh_passphrase_saved", useKeyFile ? String.valueOf(savePassphrase) : "false");
        authInfo.put("ssh_key", useKeyFile ? sshSettings.getPrivateKeyPath() : "");
        authInfo.put("ssh_passprase", useKeyFile && savePassphrase ? sshSettings.getPassPhrase() : "");
        SSLSettings sslSettings = tmp.getSSLSettings();
        boolean clientAuthEnabled = sslSettings.isAuthenticationEnabled();
        savePassphrase = sslSettings.isPassPhraseSaved();
        authInfo.put("ssl_enabled", String.valueOf(clientAuthEnabled));
        authInfo.put("ssl_certificate", clientAuthEnabled ? sslSettings.getCertificatePath() : "");
        authInfo.put("ssl_passphrase_saved", clientAuthEnabled ? String.valueOf(savePassphrase) : "false");
        authInfo.put("ssl_passphrase", clientAuthEnabled && savePassphrase ? sslSettings.getPassPhrase() : "");
        Platform.addAuthorizationInfo((URL)new URL(URL_TO_STORE), (String)location.getId(), (String)realm, authInfo);
    }

    protected void loadAuthInfo(IRepositoryLocation location, String realm) throws Exception {
        Map authInfo = Platform.getAuthorizationInfo((URL)new URL(URL_TO_STORE), (String)location.getId(), (String)realm);
        if (authInfo != null) {
            boolean toAddRealm = !realm.equals("");
            IRepositoryLocation tmp = toAddRealm ? this.newRepositoryLocation() : location;
            tmp.setUsername((String)authInfo.get("username"));
            tmp.setPasswordSaved(((String)authInfo.get("password_saved")).equals("true"));
            tmp.setPassword((String)authInfo.get("password"));
            SSHSettings sshSettings = tmp.getSSHSettings();
            sshSettings.setUseKeyFile(((String)authInfo.get("ssh_use_key")).equals("true"));
            sshSettings.setPrivateKeyPath((String)authInfo.get("ssh_key"));
            sshSettings.setPassPhraseSaved(((String)authInfo.get("ssh_passphrase_saved")).equals("true"));
            sshSettings.setPassPhrase((String)authInfo.get("ssh_passprase"));
            SSLSettings sslSettings = tmp.getSSLSettings();
            sslSettings.setAuthenticationEnabled(((String)authInfo.get("ssl_enabled")).equals("true"));
            sslSettings.setCertificatePath((String)authInfo.get("ssl_certificate"));
            sslSettings.setPassPhraseSaved(((String)authInfo.get("ssl_passphrase_saved")).equals("true"));
            sslSettings.setPassPhrase((String)authInfo.get("ssl_passphrase"));
            if (toAddRealm) {
                location.addRealm(realm, tmp);
            }
        }
    }

    public void removeAuthInfoForLocation(IRepositoryLocation location, String realm) {
        try {
            Platform.flushAuthorizationInfo((URL)new URL(URL_TO_STORE), (String)location.getId(), (String)realm);
        }
        catch (Exception ex) {
            LoggedOperation.reportError("Remove Authorization Info Operation", ex);
        }
    }

    protected void loadLocations() throws Exception {
        IEclipsePreferences repositoryPreferences = AbstractSVNStorage.getRepositoriesPreferences(this.preferencesNode);
        String[] keys = repositoryPreferences.keys();
        ArrayList<IRepositoryLocation> readLocations = new ArrayList<IRepositoryLocation>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String current = stringArray[n2];
            IRepositoryLocation location = this.newRepositoryLocation(repositoryPreferences.get(current, null));
            readLocations.add(location);
            ++n2;
        }
        this.repositories = readLocations.toArray(new IRepositoryLocation[readLocations.size()]);
    }

    protected void setStateInfoFile(IPath stateInfoLocation, String fileName) {
        this.stateInfoFile = stateInfoLocation.append(fileName).toFile();
    }

    protected void loadLocationsFromFile() throws Exception {
        ArrayList<SVNRepositoryLocation> tmp = new ArrayList<SVNRepositoryLocation>((Collection)Arrays.asList(this.repositories));
        ObjectInputStream stream = null;
        try {
            try {
                stream = new ObjectInputStream(new FileInputStream(this.stateInfoFile));
                while (true) {
                    SVNRepositoryLocation obj;
                    if (tmp.contains(obj = (SVNRepositoryLocation)stream.readObject())) {
                        continue;
                    }
                    tmp.add(obj);
                }
            }
            catch (EOFException eOFException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
    }

    protected class RepositoryPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        protected RepositoryPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            HashSet<IRepositoryLocation> readLocations = new HashSet<IRepositoryLocation>((Collection)Arrays.asList(AbstractSVNStorage.this.repositories));
            IRepositoryLocation location = AbstractSVNStorage.this.newRepositoryLocation((String)event.getNewValue());
            readLocations.add(location);
            AbstractSVNStorage.this.repositories = readLocations.toArray(new IRepositoryLocation[readLocations.size()]);
            try {
                ((IEclipsePreferences)event.getSource()).flush();
            }
            catch (BackingStoreException e) {
                LoggedOperation.reportError("preferenceChange", e);
            }
            AbstractSVNStorage.this.fireRepositoriesStateChanged(new RepositoriesStateChangedEvent(location, 0));
        }
    }
}

