/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileConflictDetectionOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CommitOperation
extends AbstractFileConflictDetectionOperation
implements IRevisionProvider {
    protected boolean recursive;
    protected boolean keepLocks;
    protected String message;
    protected ArrayList revisionsPairs;
    protected String[] paths;

    public CommitOperation(File[] files, String message, boolean recursive, boolean keepLocks) {
        super("Operation_CommitFile", SVNMessages.class, files);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public CommitOperation(IFileProvider provider, String message, boolean recursive, boolean keepLocks) {
        super("Operation_CommitFile", SVNMessages.class, provider);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        File[] files = this.operableData();
        this.defineInitialResourceSet(files);
        if (this.recursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        } else {
            FileUtility.reorder(files, true);
        }
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 4) != 0) {
            Map proxy2Resources = SVNUtility.splitRepositoryLocations(files);
            Iterator it = proxy2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
                this.performCommit(location, (List)entry.getValue(), monitor, proxy2Resources.size());
            }
        } else {
            Map project2Resources = SVNUtility.splitWorkingCopies(files);
            Iterator it = project2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false).getRepositoryLocation();
                this.performCommit(location, (List)entry.getValue(), monitor, project2Resources.size());
            }
        }
    }

    protected void performCommit(final IRepositoryLocation location, List files, final IProgressMonitor monitor, int total) {
        this.paths = FileUtility.asPathArray(files.toArray(new File[files.size()]));
        this.complexWriteToConsole(new Runnable(){

            public void run() {
                CommitOperation.this.writeToConsole(0, "svn commit");
                int i = 0;
                while (i < CommitOperation.this.paths.length && !monitor.isCanceled()) {
                    CommitOperation.this.writeToConsole(0, " \"" + CommitOperation.this.paths[i] + "\"");
                    ++i;
                }
                CommitOperation.this.writeToConsole(0, String.valueOf(CommitOperation.this.recursive ? "" : " -N") + (CommitOperation.this.keepLocks ? " --no-unlock" : "") + " -m \"" + CommitOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            }
        });
        final ISVNConnector proxy = location.acquireSVNProxy();
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                long[] revisionNumbers = proxy.commit(CommitOperation.this.paths, CommitOperation.this.message, null, ISVNConnector.Depth.infinityOrEmpty(CommitOperation.this.recursive), CommitOperation.this.keepLocks ? 16L : 0L, null, new SVNProgressMonitor(CommitOperation.this, monitor, null));
                if (revisionNumbers.length > 0) {
                    CommitOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(revisionNumbers[0], CommitOperation.this.paths, location));
                    String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(revisionNumbers[0])});
                    CommitOperation.this.writeToConsole(1, message);
                }
            }
        }, monitor, total);
        location.releaseSVNProxy(proxy);
    }

    protected void reportError(Throwable t) {
        if (t instanceof SVNConnectorUnresolvedConflictException) {
            this.hasUnresolvedConflict = true;
            this.conflictMessage = t.getMessage();
            int i = 0;
            while (i < this.paths.length) {
                Iterator it = this.processed.iterator();
                while (it.hasNext()) {
                    File res = (File)it.next();
                    if (!new Path(res.getAbsolutePath()).equals((Object)new Path(this.paths[i]))) continue;
                    it.remove();
                    this.unprocessed.add(res);
                    break;
                }
                ++i;
            }
        } else {
            super.reportError(t);
        }
    }
}

